/*
Deja News Reader
v. 1.1
14 January 1997
Eric Walker
High Boskage House
dnreader@highboskage.com

Requires Quercus Systems RexxLib & IBM EWS RxSock.

Changes:
--------
1.1 - Line 735: added LOADSDIR to exposed variables to allow Search HTML to be loaded.
      Lines 1055 & 1056 added to pop up message & return if no articles to pick from.

*/


/***SETUP & INITIALIZATION:***************************************************/

/*    Essentials:  */

Signal On SYNTAX
Signal On HALT
'cls'


/*    Initialize "global" values.  */
crlf=D2C(13)||D2C(10)
escape=D2C(27)
alfabase=64  /* ascii of "A" minus 1 */
rexxutils=0
quercuslib=0
quercuswin=0
rexxsock=0
help=0
global='rexxutils quercuslib quercuswin rexxsock crlf escape alfabase help'


/*    Rexx Function Extensions:  */

/*      Add Extended REXX Functions.  */
junk='Found RexxUtil DLL already available.'
If RxFuncQuery('SysLoadFuncs') Then
  Do
    rexxutils=1
    junk='Loaded RexxUtils DLL functions locally.'
    Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
    Call SysLoadFuncs
  End

/*      Add Quercus REXXLIB Functions.  */
text='Found RexxLib DLL already available.'
If RxFuncQuery('rexxlibregister') Then
  Do
    quercuslib=1
    text='Loaded RexxLib DLL functions locally.'
    Call RxFuncAdd 'rexxlibregister','rexxlib','rexxlibregister'
    Call RexxLibRegister
  End
Call CursorType ,,0  /* remove cursor from screen */
Call ScrWrite 1,1,Center('Setting up . . . ',80),,,31
Call ScrWrite  7,1,Center(junk,80),,,14
Call ScrWrite 11,1,Center(text,80),,,14
Call ScrWrite 25,1,Center('Loading needed DLL functions . . . ',80),,,31

/*      Add Quercus Window Functions.  */
text='Found RexxWin DLL already available.'
If RxFuncQuery('w_open') Then
  Do
    quercuswin=1
    text='Loaded RxWin DLL functions locally.'
    Call RxFuncAdd 'w_register','rxwin30','rxwindow'
    Call W_Register
  End
Call ScrWrite 15,1,Center(text,80),,,14

/*      Add RxSock DLL functions.  */
text='Found RxSock DLL already available.'
If RxFuncQuery('SockLoadFuncs') Then
  Do
    rexxsock=1
    text='Loaded RxSock DLL functions locally.'
    Call RxFuncAdd 'SockLoadFuncs','RxSock','SockLoadFuncs'
    Call SockLoadFuncs dummy
  End
Call ScrWrite 19,1,Center(text,80),,,14
Drop junk text


/*    Initializations:  */
Call ScrWrite 25,1,Center('Initializing values . . . ',80),,,31

/*      Set universals.  */
homedir=Directory()
Parse Arg poster

/*      Set scan codes.  */
pgup=D2C(73)
pgdn=D2C(81)
upkey=D2C(72)
dnkey=D2C(80)
leftkey=D2C(75)
rightkey=D2C(77)
ins=D2C(82)
del=D2C(83)
homekey=D2C(71)
endkey=D2C(79)
helpf1=D2C(59)
scancodes='pgup pgdn upkey dnkey leftkey rightkey ins del homekey endkey helpf1'

/*      Initialize over-rideable values.  */
username='nemo'
password='nemo@nowhere.org'
email='nemo@nowhere.org'
myname='anonymous'
myorg='none'
groupsdir=homedir'\GROUPS\'
loadsdir=homedir'\LOADS\'
daysback='7'
msgmax='999'
editor='E.EXE'

/*      Over-ride via CNF file.  */
Call FileRead 'DNREAD.CNF','dummy.'
Do line=1 to dummy.0
  If Pos('poster=',dummy.line)>0 Then Interpret dummy.line
  If Pos('username=',dummy.line)>0 Then Interpret dummy.line
  If Pos('password=',dummy.line)>0 Then Interpret dummy.line
  If Pos('email=',dummy.line)>0 Then Interpret dummy.line
  If Pos('myname=',dummy.line)>0 Then Interpret dummy.line
  If Pos('myorg=',dummy.line)>0 Then Interpret dummy.line
  If Pos('groupsdir=',dummy.line)>0 Then Interpret dummy.line
  If Pos('loadsdir=',dummy.line)>0 Then Interpret dummy.line
  If Pos('daysback=',dummy.line)>0 Then Interpret dummy.line
  If Pos('msgmax=',dummy.line)>0 Then Interpret dummy.line
  If Pos('editor=',dummy.line)>0 Then Interpret dummy.line
End
Drop line dummy.

/*      Initialize pointers cv.  */
pointers.0=5
Do junk=1 To 5
  pointers.junk=''
End
!nextup=1
!oneback=2
!hitlist=3
!thread=4
!author=5
Drop junk

/*      Initialize miscellaneous values.  */
gserial=0
aserial=0
groups.0=0
lastlook.0=0

/*      Load Cluster-name lists.  */
Call SysFileTree groupsdir'*.DNR','lists.','FO'
gnames.0=1+lists.0
gnames.1=' SEARCH BY KEYWORD(S)'
Do i=1 To lists.0
  Call FileRead lists.i,'dummy.'
  j=i+1
  gnames.j=dummy.1
End
Drop dummy.


/*    Net SetUp:  */
Call ScrWrite 25,1,Center('Resolving addresses . . . ',80),,,31

/*      Get queries-host dot address.  */
queryserver=NewHost('search.dejanews.com')
If queryserver='' Then Call ItQuits 'Unable to resolve query-server name--exiting.',-3

/*      Get posting-host dot address.  */
postserver=NewHost(poster)
If postserver='' Then Call ItQuits 'Unable to resolve posting-server name--exiting.',-4


/*    Set exposure groups:  */
poststuff='poster postserver username password email myname myorg editor'
artstuff='loadsdir groupname wason groupnumber artibase oldbase queryserver'


/*    Clean plate:  */
Call ScrWrite 25,1,Center('Cleaning up . . . ',80),,,31
Call SysFileTree loadsdir'*.*','dummy.','FO'
If (dummy.0)>0 Then
  Do
    If PopUp('Clean out Loads directory?',2)='Y' Then 'del 'loadsdir'*.* /Y /Q'
  End
drop dummy.



/***MAIN ACTIVITY LOOPS:******************************************************/

clusterbase=0
Do Forever  

/*  pick a Cluster  */
  lookback=daysback
  cluster=Clusters()
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
Clusters returns a cluster number (an index into cv
LISTS.) or zero (for a PowerSearch) or causes exit
from the whole program (with, obviously, no return).
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

  groupbase=0
  Do Forever  
  /*  pick a Group  */               
    loadartlist=1  /* almost always will */

    If cluster=0 Then  /* search selected as "cluster" */
      Do
        If PowerSearch() Then
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
PowerSearch either gets a search Hitlist and stores it
to disk as G0.HTML, returning 1, or it fails or is
aborted and returns zero.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
          Do
            groupname='SEARCH'  /* to avoid bypassing article selection */
            groupnumber=-1
          End
         Else groupname=''  /* will bypass article selection */
      End

     Else  /* a real cluster selected */
      Do
        groupname=GroupNames(cluster)
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
GroupNames returns either the actual name of a specific
group in the specified cluster or else a nul if group
selection is abandoned (by <Esc>).
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
        If groupname<>'' Then 
          Do
            Call ArraySearch 'groups.','found.',groupname  /* see if previously loaded */
            If found.0=1 Then
              Do
                /* this group's articles list was previously fetched */
                If found.1=groupnumber & (lastlook.groupnumber)=lookback Then loadartlist=0
                 Else  /* either not last group viewed or new LookBack */
                  Do
                    groupnumber=found.1
                    If (lastlook.groupnumber)<>lookback Then
                      Do
                        groupnumber=NewGroup(groupname,groupnumber-1)  /* -1 offsets updating */
                        If groupnumber=found.1 Then lastlook.groupnumber=lookback
                         Else 
                          Do
                            Call PopUp 'NO revised article list returned.',2,'X'
                            groupname=''
                          End
                      End
                  End
              End
             Else
              Do
                /* this is a new group, so get new article list */
                newgserial=NewGroup(groupname,gserial)
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
NewGroup gets the articles list for GROUPNAME and assigns
an updated GSERIAL to that group.  The list is saved
to disk as Ggserial.HTML; if it fails to load a list,
it returns zero.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
                If newgserial>0 Then
                  Do
                    /* update "loaded" cv list with new group */
                    gserial=newgserial
                    groupnumber=gserial
                    groups.0=gserial
                    groups.gserial=groupname
                    lastlook.0=gserial
                    lastlook.gserial=lookback
                  End  /* got new art list ok */
                 Else 
                  Do
                    Call PopUp 'NO article list returned.',2,'X'
                    groupname=''
                  End

              End  /* art list not previously gotten */
          End  /* group picked from cluster */

      End  /* real cluster selected */
    If groupname='' Then Leave  /* go back to cluster selection */
      
    /*  pick an Article  */
    artibase=0
    query=''
    Do Forever
      If query='' Then  /* no outstanding request to fill */
        Do
          If groupnumber=0 Then loadartlist=1  /* requested threadlist or hitlist */
          If groupnumber<1 Then Call ScrWrite 1,1,Center('Articles found by Search:',80),,,31
           Else Call ScrWrite 1,1,Center('Current Articles list, 'groupname':',80),,,31
          If groupnumber>=0 Then 
            Do
              query=PickArticle(groupnumber,loadartlist)              
              If query='' & groupnumber=0 Then  /* leaving thread or search picking */
                Do
                  Call ScrClear 7,' ',2,1,23,80
                  Call ScrWrite 25,1,Center('Reloading group article list . . . ',80),,,31
                  groupnumber=wason
                  artibase=oldbase
                  query=PickArticle(groupnumber,1)
                End
            End
           Else query=PickHit()
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
PickArticle & PickHit return the needed query string for 
fetching the article, or a nul if selection was aborted.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
        End
      If query='' Then Leave  /* article selection finished */

      Call ScrWrite 1,1,Center('Getting requested information . . . ',80),,,31
      newaserial=MakeQuery(query,queryserver,aserial,'A')
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named Aserial.HTML, updating ASERIAL as it does so;
it returns the updated ASERIAL or, for any failure, 0.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
      If newaserial=0 Then 
        Do
          query=''  /* avoid endless retries */
          Call PopUp 'Article NOT returned.',5,'X'
        End
      If newaserial=0 Then Iterate

      aserial=newaserial
      If ReadArticle(aserial)>0 Then query=ViewArticle(aserial)  /* follow-on requested */
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
ReadArticle converts the HTML to two files: the header
info (Haserial.TXT) and the text proper (Aaserial.TXT).
It also leaves pointers to other jumps in cv POINTERS.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
       Else 
        Do
          query=''  /* avoid endless retries */
          Call PopUp 'Article contained NO usable references.',1,'X'
        End
    End  /*  pick-article loop  */
    If cluster=0 Then Leave  /* don't keep going back to search setup */
  End  /*  pick-group loop  */
End  /*  pick-cluster loop  */

Exit  /* paranoia */



/***ROUTINES:*****************************************************************/

/*------Posting Routine:-----------------------------------------------------*/
PostIt:
Procedure Expose (global) groupname loadsdir (poststuff)
Parse Arg aserial,mode
ec=0  /* assume the worst (0=fail, 1=ok) */
If mode='P' & groupname='SEARCH' Then Call PopUp 'Cannot originate articles from Search.',7,'X'
If mode='P' & groupname='SEARCH' Then Return ec
Call ScrWrite 1,1,Center('Posting message via 'poster' . . . ',80),,,31
If mode='R' Then
  Do
    /*  Get info on message to be replied to.  */
    Call FileRead loadsdir'H'aserial'.TXT','oldhead.'
    newsgroups='?'
    subject='?'
    messageid='?'
    messagedate='?'
    author='?'
    Do line=1 To oldhead.0
      If Pos('Newsgroups:',oldhead.line)>0 Then newsgroups=LineValue(oldhead.line)
      If Pos('Subject:',oldhead.line)>0 Then subject=LineValue(oldhead.line)
      If Pos('Message-',oldhead.line)>0 Then messageid=LineValue(oldhead.line)
      If Pos('Date:',oldhead.line)>0 Then messagedate=LineValue(oldhead.line)
      If Pos('From:',oldhead.line)>0 Then author=LineValue(oldhead.line)
    End    
    /*  Create new article from old.  */
    Call ScrWrite 25,1,Center('Creating reply . . . ',80),,,31
    Call FileRead loadsdir'A'aserial'.TXT','oldmsg.'
    dummy.0=7+oldmsg.0
    dummy.1='On 'messagedate', in message 'messageid','
    dummy.2=author' wrote:'
    dummy.3=Copies('-',70)
    Do line=1 To oldmsg.0
      my=3+line
      dummy.my='| 'oldmsg.line
    End
    my=(dummy.0)-3
    dummy.my=Copies('=',70)
    my=my+1
    dummy.my='based on which I say:'
    my=my+1
    dummy.my=''
    my=my+1
    dummy.my=''
    Drop oldmsg.
    Call FileWrite loadsdir'TOSEND.TXT','dummy.'
    Drop dummy.
    editor loadsdir'TOSEND.TXT'
    Call ScrWrite 25,1,Center('Reply ready.',80),,,31
    If PopUp('Send the article?',5)='N' Then Return 1
    /*  Attach Header  */
    Call FileRead loadsdir'TOSEND.TXT','text.'
    If Upper(Left(subject,4))<>'RE: ' Then subject='Re: 'subject
    mymessage.0=8
    mymessage.1='From: 'myname' <'email'>'
    mymessage.2='Date: 'Left(Date('Weekday'),3)', 'Date('Normal')' 'Time()' PST'
    mymessage.3='Newsgroups: 'newsgroups
    mymessage.4='Subject: 'subject
    mymessage.5='References: 'messageid
    mymessage.6='Organization: 'myorg
    mymessage.7='Lines: '4+text.0
    mymessage.8=''
  End
 Else
  Do
    /*  Create new article.  */
    Call ScrWrite 25,1,Center('Creating new message . . . ',80),,,31
    temp=W_Open(2,1,23,80,8)
    Call W_Border temp
    Call W_ScrWrite temp,10,2,Center('Enter below a SUBJECT heading for this article:',78)
    subject=W_Get(temp,12,6,65)
    Call W_Close temp
    Call CursorType ,,0
    If subject='' Then Leave  /* leave the current DO */
    dummy.0=3
    dummy.1=subject':'
    dummy.2=Copies('-',70)
    dummy.3=''
    Call FileWrite loadsdir'TOSEND.TXT','dummy.'
    Drop dummy.
    editor loadsdir'TOSEND.TXT'
    Call ScrWrite 25,1,Center('New message ready.',80),,,31
    If PopUp('Send the article?',5)='N' Then Return 1
    /*  Attach Header  */
    Call FileRead loadsdir'TOSEND.TXT','text.'
    mymessage.0=7
    mymessage.1='From: 'myname' <'email'>'
    mymessage.2='Date: 'Left(Date('Weekday'),3)', 'Date('Normal')' 'Time()' PST'
    mymessage.3='Newsgroups: 'groupname
    mymessage.4='Subject: 'subject
    mymessage.5='Organization: 'myorg
    mymessage.6='Lines: '4+text.0
    mymessage.7=''
  End
If subject='' Then Return ec
Call ArrayInsert 'text.','mymessage.'
Drop text.    
/*  Attach Sig.  */
Call FileRead 'DNREAD.SIG','dummy.'
If dummy.0=0 Then
  Do
    dummy.0=4
    dummy.1=''
    dummy.2=Copies(':',70)
    dummy.3=myname
    dummy.4=myorg
  End
Do While dummy.0<4
  top=1+dummy.0
  dummy.top=''
  dummy.0=top
End
Call ArrayInsert 'dummy.','mymessage.'
Drop dummy.
/*  Connect to server for a socket.  */
Call ScrWrite 25,1,Center('Connecting . . . ',80),,,31
socket=SockSocket("AF_INET","SOCK_STREAM",0)
If socket=-1 Then
  Do
    Call Sound 300,.3
    Call ScrWrite 25,1,Center('Error opening socket!  (Press any key to continue.)',80),,,79
    Call InKey
  End
If socket=-1 Then Return 0
/*  Log on to the socket.  */
Call ScrWrite 25,1,Center('Logging on . . . ',80),,,31
server.!family='AF_INET'  /* mandatory  */
server.!port=119  /*  standard news port  */
server.!addr=postserver  /* as obtained earlier  */
got=SockConnect(socket,'server.!')
If got=-1 Then
  Do
    Call Sound 300,.3
    Call ScrWrite 25,1,Center('Error logging on to socket!  (Press any key to continue.)',80),,,79
    Call InKey
  End
If got=-1 Then Return 0
/*  Get server's initial response.  */
got=GetALine(socket)
Parse Var got code meaning
ok=0
Select
  When code='200' Then ok=1
  When code='201' Then Call PopUp poster' does not allow posting.',4,'X'
  When code='400' Then Call PopUp poster' broke contact ('meaning').',4,'X'
  Otherwise Call PopUp poster': 'meaning'--cannot continue',4,'X'
End
If \ok Then got=GoodBye(socket)
If \ok Then Return 0
/*  Test for needed authentication.  */
Call ScrWrite 25,1,Center('Initiating post . . . ',80),,,31
Call SendLine 'POST',socket
got=GetALine(socket)
Parse Var got code meaning
ok=1
If code='480' Then
  Do
    Call ScrWrite 25,1,Center('Authenticating with server . . . ',80),,,31
    Call SendLine 'authinfo user 'username,socket
    got=GetALine(socket)
    Parse Var got code meaning
    If code='381' Then
      Do
        Call SendLine 'authinfo pass 'password,socket
        got=GetALine(socket)
        Parse Var got code meaning
      End
    Select
      When code='281' Then 
        Do
          Call ScrWrite 25,1,Center('Authentication complete; stand by. ',80),,,31
          Call SendLine 'POST',socket
          got=GetALine(socket)
          Parse Var got code meaning
        End
      When code='482' Then 
        Do
          Call PopUp 'Authentication rejected!--exiting.',4,'X'
          ok=0
        End
      When code='502' Then 
        Do
          Call PopUp 'No permission on 'poster'--exiting.',4,'X'
          ok=0
        End
      Otherwise
        Do
          Call PopUp 'Unexpected response ('meaning')--exiting.',4,'X'
          ok=0
        End
    End
  End  /* authentication requested  */
If \ok Then got=GoodBye(socket)
If \ok Then Return 0
If code<>'340' Then Call PopUp 'Will be unable to post--exiting.',4,'X'
If code<>'340' Then Return 0
/*  Actually send message.  */
Do line=1 To mymessage.0
  If Left(mymessage.line,1)='.' Then tosend='.'||mymessage.line
   Else tosend=mymessage.line
  Call SendLine tosend,socket
  Call ScrWrite 25,1,Center('Sending line 'line' of 'mymessage.0' . . . ',80),,,31
End
Call SendLine '.',socket  /* end-of-message marker */
/*  Check response to send.  */
Call ScrWrite 25,1,Center('Awaiting confirmation . . . ',80),,,31
got=GetALine(socket)
Parse Var got code meaning
ok=1
Call Sound 1500,.1
Select 
  When code='240' Then 
    Do
      ec=1
      Call ScrWrite 1,1,Center('Message posted OK.',80),,,31
    End
  When code='440' Then Call ScrWrite 1,1,Center('Posting disallowed! ('meaning')',80),,,79
  Otherwise Call ScrWrite 1,1,Center('Posting failed!  ('meaning')',80),,,79
End
Call ScrWrite 25,1,Center('Logging off 'poster' . . . ',80),,,31
/*  Exit civilly.  */
got=GoodBye(socket)
Return ec


/*------Major Routines:------------------------------------------------------*/

Clusters:
/*  Select an interest-cluster from extant file collection  */
Procedure Expose (global) clusterbase (scancodes) gnames.
Call Sound 900,.1
Call ScrWrite 1,1,Center('Interest-Cluster Selection Screen:',80),,,31
Call ScrWrite 25,1,Center('Select an interest cluster by indicator letter (<Esc> quits).',80),,,31
Call ArrayCopy 'gnames.','choices.'
choicebase=clusterbase
Do Until cluster>0
  help=1
  cluster=GetChoice(' ',3)
  help=0
  If cluster=0 Then
    Do
      If PopUp('Do you really want to exit this program?',4)='Y' Then ,
         Call ItQuits 'Normal exit.',0
    End
End
choice=cluster-1  /* 1 is lowest return from GetChoice */
clusterbase=choicebase
Call ScrClear
Return choice

     
GroupNames:
Procedure Expose (global) groupbase lookback (scancodes) lists.
Parse Arg cluster
Call FileRead lists.cluster,'grouplist.'
Call Sound 700,.1
Call ScrWrite 1,1,Center('Specific-NewsGroup Selection Screen,'grouplist.1' Interest Cluster:',80),,,31
Call ScrWrite 25,1,Center('Select a group by indicator letter (<Esc> quits).',80),,,31
Call ArrayCopy 'grouplist.','choices.',2  /*  leave title line out of choices cv  */
choicebase=groupbase
help=2
pick=GetChoice('',6)
help=0
index=pick+1  /* cv choice is 1 off from cv grouplist (title line) */
If pick>0 Then groupname=grouplist.index
 Else groupname=''
groupbase=choicebase
Call ScrClear
Return groupname


MakeQuery:
Procedure Expose (global) loadsdir
Parse Arg query,serveraddr,serial,type
/*  Connect to server for a socket.  */
Call ScrWrite 25,1,Center('Connecting . . . ',80),,,31
socket=SockSocket("AF_INET","SOCK_STREAM",0)
If socket=-1 Then
   Do
     Call Sound 300,.3
     Call ScrWrite 25,1,Center('Error opening socket!  (Press any key to continue.)',80),,,79
     Call InKey
   End
If socket=-1 Then Return 0
/*  Log on to the socket.  */
Call ScrWrite 25,1,Center('Logging on to socket 'socket' . . . ',80),,,31
server.!family='AF_INET'  /* mandatory  */
server.!port=80  /*  standard HTTP port  */
server.!addr=serveraddr  /* as obtained earlier  */
got=SockConnect(socket,'server.!')
If got=-1 Then
   Do
     Call Sound 300,.3
     Call ScrWrite 25,1,Center('Error logging on to socket!  (Press any key to continue.)',80),,,79
     Call InKey
   End
If got=-1 Then Return 0
/*  Send actual service request.  */
Call ScrClear 7,' ',2,1,23,80
Call ScrWrite 25,1,Center('Sending request . . . ',80),,,31
cut=Pos('?',query)
target=Left(query,cut-1)
query=SubStr(query,cut+1)
Call SendLine 'POST 'target' HTTP/1.0',socket
Call SendLine 'Accept: *'||'/'||'*; q=0.300',socket
Call SendLine 'Accept: application/octet-stream; q=0.100',socket
Call SendLine 'Accept: text/plain',socket
Call SendLine 'Accept: text/html',socket
Call SendLine 'User-Agent: IBM-RxSock-DLL/v1.1',socket
Call SendLine 'Content-type: application/x-www-form-urlencoded',socket
qline='Content-length: 'Length(query)
Call SendLine qline,socket
Call SendLine '',socket
Call SendLine query,socket
Call ScrWrite 25,1,Center('Request sent . . . ',80),,,31
buffer=''
Call Time('R')
Do Until buffer<>'' & data=''
  If Time('E')>120 Then Leave
  rc=SockRecv(socket,'data',8000)
  If buffer='' Then Call ScrWrite 25,1,Center('Receiving reply . . . ',80),,,31
  buffer=buffer||data
  If data<>'' Then Call Time('R')
  Call ScrWrite 13,1,Center(Length(buffer)' bytes received . . . ',80),,,14
End
/*  Close socket before proceeding.  */
got=SockSoClose(socket)
If got=-1 Then Call ItQuits 'Error closing socket.',-6
/*  Process response, if any.  */
If buffer<>'' Then
  Do
    ok=serial+1
    dummy.0=1
    dummy.1=buffer
    Call ScrWrite 25,1,Center('Reply received; parsing/saving . . . ',80),,,31
    Call FileWrite loadsdir||type||ok'.HTML','dummy.'
    Call ScrWrite 25,1,Center('Reply complete; stand by for list display . . . ',80),,,31
  End
 Else 
   Do
     ok=0
     Call PopUp 'Error receiving response.',6,'X'
   End
Return ok


PickArticle:
Procedure Expose (global) (scancodes) loadsdir artibase hrefs. hits.
Parse Arg tosee,loadartlist
/*  Extract hits/hrefs and pointers from raw file.  */
If loadartlist Then 
  Do
    Call FileRead loadsdir'G'tosee'.HTML','artlist.'  /* get raw html articles list */
    hits.0=0
    hrefs.0=0
    art=0
    inset=-1
    Do line=1 to artlist.0
      If Pos('<UL>',artlist.line)>0 Then inset=inset+1
      If Pos('</UL>',artlist.line)>0 Then inset=inset-1
      If Pos('<LI>',artlist.line)>0 Then
        Do
          art=art+1
          hits.art=Copies(' ',3*inset)||DeHtml(artlist.line)
          hrefs.art=GetPointer(artlist.line)
        End
    End
    hits.0=art
    hrefs.0=art
  End
help=3
toread=GetPickFromList()
help=0
Return toread


PickHit:
Procedure Expose (global) (scancodes) artibase loadsdir
/*  Load raw HTML.  */
Call FileRead loadsdir'G0.HTML','artlist.'  /* get raw html articles list */
/*  Extract hits/hrefs and pointers from raw file.  */
hits.0=0
hrefs.0=0
art=0
Do line=1 to artlist.0
  If Pos('.',Left(artlist.line,6))>0 & Pos('<A HREF="http://',artlist.line)>0 Then
    Do
      art=art+1
      hits.art=DeHtml(artlist.line)
      hrefs.art=GetPointer(artlist.line)
    End
End
artibase=0
hits.0=art
hrefs.0=art
help=4
toread=GetPickFromList()
help=0
Return toread


ReadArticle:
Procedure Expose (global) loadsdir pointers.
Parse Arg aserial
Call FileRead loadsdir'A'aserial'.HTML','text.'
Call ScrWrite 25,1,Center('Converting 'text.0' HTML lines to straight text . . . ',80),,,31
Do ptr=1 To 5
  pointers.ptr=''
End
header.0=0
h=0
Do line=1 To text.0
  If Pos('[Next]',text.line)>0 Then pointers.!nextup=GetPointer(text.line)
  If Pos('[Previous]',text.line)>0 Then pointers.!oneback=GetPointer(text.line)
  If Pos('[Hitlist]',text.line)>0 Then pointers.!hitlist=GetPointer(text.line)
  If Pos('[Get Thread]',text.line)>0 Then pointers.!thread=GetPointer(text.line)
  If Pos('[Author Profile]',text.line)>0 Then pointers.!author=GetPointer(text.line)
  If Pos('<HR><H3>',text.line)>0 Then Leave
End
dummy=line+1
/*  Now in first Header line  */
Do line=dummy To text.0
  If Strip(text.line)='<BR>' Then Leave
  h=h+1
  header.h=DeHtml(text.line)
End
header.0=h
dummy=line
If h>0 Then Call FileWrite loadsdir'H'aserial'.TXT','header.'
/*  Now in first Article line  */
article.0=0
a=0
Do line=dummy To text.0
  If Pos('</PRE>',text.line)>0 Then Leave
  a=a+1
  article.a=DeHtml(text.line)
End
article.0=a
If a>0 Then Call FileWrite loadsdir'A'aserial'.TXT','article.'
Return a


ViewArticle:
Procedure Expose (global) (scancodes) (artstuff) (poststuff) pointers.
Parse Arg aserial
Call FileRead loadsdir'A'aserial'.TXT','text.'
Call ScrWrite 1,1,Center('Article text:',80),,,31
answer=''
count=text.0
baseline=0
inset=0
done=0
temp=W_Open(2,1,23,80,96)
help=5
Do Until done
  /*  Display 23-line window of text.  */
  top=baseline+23
  If top>count Then top=count
  Call ScrWrite 25,1,Center('Lines 'baseline+1' to 'top' of article.',80),,,31
  maxlength=0
  Do row=1 To top
    index=row+baseline
    Call W_ScrWrite temp,row,1,SubStr(text.index,1+inset,80)
    If Length(text.index)>maxlength Then maxlength=Length(text.index)
  End
  /*  Get a valid keypress.  */
  ok=0
  Do Until ok | done
    pressed=InKey()
    If Length(pressed)=1 Then 
      Do
        scancode=0
        If pressed=escape Then done=1
         Else Call Sound 40,.5
      End
     Else 
      Do
        scancode=Right(pressed,1)
        pressed=''
        Select
          When scancode=pgup Then
            Do
              ok=1
              If baseline=0 Then Call Sound 200,.1
               Else baseline=baseline-23
            End
          When scancode=pgdn Then
            Do
              ok=1
              If baseline>=(count-23) Then Call Sound 1300,.1
               Else 
                Do
                  baseline=baseline+23
                  If (baseline+24)>count Then baseline=count-23
                End
            End
          When scancode=homekey Then 
            Do
              ok=1
              If baseline=0 Then Call Sound 200,.1
               Else baseline=0
            End
          When scancode=endkey Then 
            Do
              ok=1
              If baseline=count-23 Then Call Sound 1300,.1
               Else baseline=count-23
            End
          When scancode=leftkey Then
            Do
              ok=1
              If inset=0 Then Call Sound 200,.1
               Else inset=inset-10
            End
          When scancode=rightkey Then
            Do
              ok=1
              If inset>=(maxlength-80) Then Call Sound 1300,.1
               Else 
                Do
                  inset=inset+10
                  If (inset+80)>maxlength Then inset=maxlength-80
                End
            End
          When scancode=helpf1 Then 
            Do
              Call ShowHelp
            End
/*::::::::Special-call keys:::::::::::::::::::::::::::::::::::::::::::*/
          When scancode=D2C(31) Then  /* Alt-S save */
            Do
              ok=1
              Call SaveIt aserial
            End
          When scancode=D2C(19) Then  /* Alt-R reply */
            Do
              ok=1
              Call PostIt aserial,'R'
            End
          When scancode=D2C(20) Then  /* Alt-T thread */
            Do
              If pointers.!thread<>'' Then
                Do
                  done=1
                  wason=groupnumber
                  groupnumber=0
                  oldbase=artibase
                  artibase=0
                  answer=''
                  Call MakeQuery pointers.!thread,queryserver,-1,'G'
                End
               Else Call Sound 40,.5
            End
          When scancode=D2C(25) Then  /* Alt-P post new */
            Do
              ok=1
              Call PostIt aserial,'P'
            End
          When scancode=D2C(30) Then  /* Alt-A author info */
            Do
              If pointers.!author<>'' Then
                Do
                  ok=1
                  Call Profile pointers.!author
                End
               Else Call Sound 40,.5
            End
          When scancode=D2C(33) Then  /* Alt-F forward */
            Do
              If pointers.!nextup<>'' Then
                Do
                  done=1
                  answer=pointers.!nextup
                End
               Else Call Sound 40,.5
            End
          When scancode=D2C(35) Then  /* Alt-H header */
            Do
              ok=1
              Call ShowHeader(aserial)
            End
          When scancode=D2C(38) Then  /* Alt-L list of hits */
            Do
NOP
/*
              If pointers.!hitlist<>'' Then
                Do
                  done=1
                  wason=groupnumber
                  groupnumber=0
                  oldbase=artibase
                  artibase=0
                  answer=''
                  Call MakeQuery pointers.!hitlist,queryserver,-1,'G'
                End
               Else Call Sound 40,.5
*/
            End
          When scancode=D2C(48) Then  /* Alt-B back */
            Do
              If pointers.!oneback<>'' Then
                Do
                  done=1
                  answer=pointers.!oneback
                End
               Else Call Sound 40,.5
            End
          Otherwise Call Sound 40,.5
        End  /* Select on scancode */
      If baseline<0 Then baseline=0
      If inset<0 Then inset=0
      End  /* scankey pressed */
  End  /* get & process keypress */
  If \ok & \done Then Call Sound 40,.5
End
help=0
Call W_Close temp
Call CursorType ,,0
Return answer


PowerSearch:
Procedure Expose (global) msgmax queryserver loadsdir
Call ScrWrite 1,1,Center('Power Search:',80),,,31
Call ScrWrite 25,1,Center('Setting up Search criteria . . . ',80),,,31
temp=W_Open(2,1,23,80,7)
Call W_ScrWrite temp,3,5,'Enter the search-target word or words below (<Esc> aborts):',,,14
entry=W_Get(temp,5,10,42,,95)
Call CursorType ,,0
If entry='' Then 
  Do
    Call W_Close temp
  End
If entry='' Then Return 0
Call W_ScrWrite temp,3,5,'Search-target word(s):',75,,14
Call W_ScrWrite temp,5,10,entry,42,,95
/*-------------------------
substitute <F2+> (without
brackets) for a separator
space, and % for a / char.
(Probably need others.)
-------------------------*/
searchwords=Translate(entry,'%','/')
multiword=0
Do While Pos(' ',searchwords)>0
  multiword=1
  blank=Pos(' ',searchwords)
  searchwords=Left(searchwords,blank-1)||'F2+'||SubStr(searchwords,blank+1)
End
op='AND'
If multiword Then
  Do
    Call W_ScrWrite temp,8,5,'Press "O" for OR of searchwords or any other key for AND:',,,14
    pressed=Upper(Inkey())
    If pressed='O' Then op='OR'
  End
Call W_Close temp
Call CursorType ,,0
Call ScrClear 7,' ',2,1,23,80
Call ScrWrite 4,5,'Search-target word(s):',75,,14
Call ScrWrite 6,10,entry,42,,95
Call ScrWrite 9,5,'Searchwords Boolean combiner:',75,,14
Call ScrWrite 11,10,op,4,,95
Call ScrWrite 25,1,Center('Sending Search request . . . ',80),,,31
query='/dnquery.xp?'||,
      'query='searchwords||,
      '&defaultop='op||,
      '&svcclass=dncurrent'||,
      '&maxhits='msgmax||,
      '&format=terse'||,
      '&threaded=0'||,
      '&showsort=score'||,
      '&agesign=1'||,
      '&ageweight=1'
artlist=MakeQuery(query,queryserver,-1,'G')
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named Gserial.HTML, updating GSERIAL as it does so;
it returns the updated GSERIAL or, for any failure, 0.
Here, the initial Gserial is forced to -1, yielding
a disk file of G0.HTML for all successes.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
If artlist<0 Then 
  Do
    success=0
    Call PopUp 'Search failed somehow.',5,'X'
  End
 Else success=1
Return success


/*------Lesser Routines:----------------------------------*/

GetPickFromList:
Procedure Expose (global) (scancodes) hrefs. hits. artibase
/*  Display list and get choice.  */
art=hits.0
If art=0 Then Call PopUp 'There are NO articles available from this group or search.','3,'X'
If art=0 Then Return ''
Do Until picked
  /*  Display 22-line window of list selections.  */
  top=24
  Do row=3 To 24
    inset=(row-2)+artibase  /* row 3 is "A" */
    If inset<=art Then
      Do
        If hrefs.inset='' Then
          Do
            leader='   '
            attr=2
          End
         Else
          Do
            leader=D2C(row-2+alfabase)': '
            attr=10
          End
        Call ScrWrite row,1,leader||Left(hits.inset,77),,,attr
      End
     Else 
      Do
        Call ScrWrite row,1,' ',80,' ',2
        If row<top Then top=row
      End
  End
  Call ScrWrite 2,1,Center('List lines 'artibase+1' To 'artibase+top-2,80),,,15
  /*  Get valid user choice.  */
  top=D2C(top-2+alfabase)
  allowed=XRange('A',top)
  Call ScrWrite 25,1,Center('Pick an Article by corresponding letter key.',80),,,31
  ok=0
  Do Until ok
    pressed=InKey()
    If Length(pressed)=1 Then 
      Do
        scancode=0
        pressed=Upper(pressed)
        If pressed=escape Then ok=1
        If Verify(pressed,allowed,'Match') | pressed=escape Then 
          Do
            index=artibase+C2D(pressed)-alfabase
            If hrefs.index<>'' Then ok=1
          End
      End
     Else 
      Do
        scancode=Right(pressed,1)
        pressed=''
        Select
          When scancode=pgup |,
               scancode=pgdn |,
               scancode=homekey |,
               scancode=endkey |,
               scancode=helpf1 Then ok=1
          Otherwise ok=0
        End
      End
    If \ok Then Call Sound 40,.5
  End
  /*  Process choice as appropriate.  */
  picked=0
  If scancode>0 Then
    Do
      Select
        /*  Screen-change keys.  */
        When scancode=pgup Then
          Do
            If artibase=0 Then Call Sound 200,.1
             Else artibase=artibase-22
            If artibase<0 Then artibase=0
          End
        When scancode=pgdn Then
          Do
            If artibase>=art-22 Then Call Sound 1300,.1
             Else artibase=artibase+22
            If (artibase+22)>=art Then artibase=art-22
          End
        When scancode=homekey Then 
          Do
            If artibase=0 Then Call Sound 200,.1
             Else artibase=0
          End
        When scancode=endkey Then 
          Do
            If artibase>=art-22 Then Call Sound 1300,.1
             Else artibase=art-22
            If artibase<0 Then artibase=0
          End
        When scancode=helpf1 Then 
          Do
            Call ShowHelp
          End
        Otherwise Call Sound 40,.5  /* "valid" but undefined key */
      End  /* Select scancode */
    End  /* nonascii key used */
   Else
    Do
      picked=1
      If pressed=escape Then toread=''
       Else toread=hrefs.index  /* calculated in appraising keypress validity */
    End
End
Return toread


NewHost:
Procedure Expose (global)
Parse Arg service
If SockGetHostByName(service,'host.!')=0 Then serveraddr=''
 Else serveraddr=host.!addr
Return serveraddr


NewGroup:
Procedure Expose (global) msgmax lookback queryserver loadsdir
Parse Arg groupname,gserial
query='/rn_print.xp?'||,
      'search=word'||,
      '&svcclass=dncurrent'||,
      '&threaded=1'||,
      '&maxhits='msgmax||,
      '&showsort=date'||,
      '&agesign=1'||,
      '&ageweight=3'||,
      '&days='lookback||,
      '&group='groupname
Call ScrWrite 1,1,Center('Getting current Articles list for 'groupname' . . . ',80),,,31
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named Gserial.HTML, updating GSERIAL as it does so;
it returns the updated GSERIAL or, for any failure, 0.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
artlist=MakeQuery(query,queryserver,gserial,'G')  /* extant GSERIAL */
Return artlist


GetChoice:
Procedure Expose (global) (scancodes) choicebase choices. lookback
Parse Arg forblanks,attr
count=choices.0
If count>11 Then skip=1
 Else skip=2
pick=-1
Call ScrClear attr,' ',2,1,23,80
Do Until pick>=0
  /*  Display 23-line window of choices.  */
  top=choicebase+23
  If top>count Then top=count
  Do index=choicebase+1 To top
    row=1+((index-choicebase)*skip)
    If Strip(choices.index)='' Then Call ScrWrite row,1,Copies(forblanks,80)
     Else Call ScrWrite row,1,D2C(index-choicebase+alfabase)||': 'Left(choices.index,77),80,' ',attr
  End
  /*  Get a valid keypress.  */
  top=D2C(top-choicebase+alfabase)
  allowed=XRange('A',top)
  ok=0
  Do Until ok
    pressed=InKey()
    If Length(pressed)=1 Then 
      Do
        scancode=0
        pressed=Upper(pressed)
        If Verify(pressed,allowed,'Match') | pressed='+' | pressed=escape Then ok=1
        If forblanks=' ' & pressed='+' Then ok=0  /* only in group selection */
      End
     Else 
      Do
        scancode=Right(pressed,1)
        pressed=''
        Select
          When scancode=pgup |,
               scancode=pgdn |,
               scancode=homekey |,
               scancode=endkey |,
               scancode=helpf1 Then ok=1
          Otherwise ok=0
        End
      End
    If \ok Then Call Sound 40,.5
  End
  /*  Process valid keypresses.  */
  If scancode>0 Then
    Do
      Select
        When scancode=pgup Then
          Do
            If choicebase=0 Then Call Sound 200,.1
             Else choicebase=choicebase-23
          End
        When scancode=pgdn Then
          Do
            If choicebase>=(count-23) Then Call Sound 1300,.1
             Else 
              Do
                choicebase=choicebase+23
                If (choicebase+24)>count Then choicebase=count-23
              End
          End
        When scancode=homekey Then 
          Do
            If choicebase=0 Then Call Sound 200,.1
             Else choicebase=0
          End
        When scancode=endkey Then 
          Do
            If choicebase=count-23 Then Call Sound 1300,.1
             Else choicebase=count-23
          End
        When scancode=helpf1 Then 
          Do
            Call ShowHelp
          End
      End
      If choicebase<0 Then choicebase=0
    End
   Else
    Do
      Select
        When pressed=escape Then pick=0
        When pressed='+' Then lookback=HowFar(lookback)
        Otherwise pick=choicebase+(C2D(pressed))-alfabase
      End
    End
End
Return pick


SendLine:
Procedure Expose (global)
Parse Arg tosend,socket
data=tosend||crlf
Do Forever
  If SockSend(socket,data)=Length(data) Then Leave
   Else
    Do
      pressed=PopUp('Failure sending command line.  Retry?',3)
      If pressed='N' Then Call ItQuits 'Fatal error trying to send to server.',-7
    End
End
Return


GetALine:
/*  For NNTP use.  */
Procedure Expose (global)
Parse Arg socket
buffer=''
Do While Pos(crlf,buffer)=0
  rc=SockRecv(socket,'data',8000)
  If rc<>-1 Then buffer=buffer||data
End
cut=Pos(crlf,buffer)
If cut>0 Then 
  Do
    got=SubStr(buffer,1,cut-1)
    buffer=SubStr(buffer,cut+2)  /*  keep any excess for later  */
  End
 Else got='### BAD RECEIVE ###'
Return got


GetPointer:
Procedure Expose (global)
Parse Arg item
start=Pos('<A HREF="http://xp',item)
If start=0 Then Return ''
 Else start=start+16
cut=Pos('">',item,start)
If cut>0 Then 
  Do
    ref=SubStr(item,start,cut-start)
    If ref<>'' Then
      Do
        start=Pos('/',ref)
        query=SubStr(ref,start)
      End
  End
 Else query=''
Return query


DeHtml:
Procedure Expose (global)
Parse Arg item
Do While Pos('<',item)>0
  start=Pos('<',item)
  cut=Pos('>',item,start)
  If cut=0 Then item=Left(item,start-1)
   Else item=Left(item,start-1)||SubStr(item,cut+1)
End
Do While Pos('&lt;',item)>0
  start=Pos('&lt;',item)
  item=Left(item,start-1)||'<'||SubStr(item,start+4)
End
Do While Pos('&gt;',item)>0
  start=Pos('&gt;',item)
  item=Left(item,start-1)||'>'||SubStr(item,start+4)
End
Do While Pos('&quot;',item)>0
  start=Pos('&quot;',item)
  item=Left(item,start-1)||'"'||SubStr(item,start+6)
End
Do While Pos('&amp;',item)>0
  start=Pos('&amp;',item)
  item=Left(item,start-1)||'&'||SubStr(item,start+6)
End
Return item


LineValue:
Procedure Expose (global)
Parse Arg linevalue
start=Pos(':',linevalue)
linevalue=Strip(SubStr(linevalue,start+1))
Return linevalue


Profile:
Procedure Expose (global) (scancodes) queryserver loadsdir pointers.
Parse Arg query
Call ArrayCopy 'pointers.','holder.'  /* preserve... */
Call ScrWrite 1,1,Center('Getting author profile . . . ',80),,,31
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named P999.HTML; it returns 999 for success or,
for any failure, 0.  It must be fed 998 as dummy serial.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
ok=MakeQuery(query,queryserver,998,'P')  /* 998=dummy "serial" value */
Call ArrayCopy 'holder.','pointers.'  /* ...and restore */
If ok=0 Then Call PopUp 'Profile NOT returned.',7,'X'
 Else
  Do
    Call ScrWrite 25,1,Center('Parsing author profile . . . ',80),,,31
    text.0=0
    t=0
    Call FileRead loadsdir'P999.HTML','html.'
    inset=0
    Do line=1 To html.0
      If Pos('>UTHOR PROFILE: ',html.line)>0 Then 
        Do
          t=t+1
          build='  Author Profile, message '
          start=16+Pos('>UTHOR PROFILE: ',html.line)
          cut=Pos('<',html.line,start)
          snip=SubStr(html.line,start,cut-start)
          text.t=DeHtml(snip)
          t=t+1
          text.t=Copies('=',70)
        End
      If Pos('<UL>',html.line)>0 Then inset=inset+1
      If Pos('</UL>',html.line)>0 Then inset=inset-1
      If Pos('<LI>',html.line)>0 Then
        Do
          t=t+1
          text.t=Copies(' ',inset*3)||DeHtml(html.line)
        End
    End
    If t>0 Then
      Do
        Call ScrWrite 1,1,Center('Author profile:',80),,,31
        Call ScrWrite 25,1,Center(text.1,80),,,31
        t=t+1
        text.t=''
        text.0=t
        temp=W_Open(2,1,23,80,112)
        probase=2
        done=0
        help=6
        Do Until done
          Do row=1 To 23
            index=row+probase
            If index<text.0 Then Call W_ScrWrite temp,row,1,Left(text.index,80)
             Else Call W_ScrWrite temp,row,1,Copies(' ',80)
          End
          pressed=InKey()
          If Length(pressed)=1 Then 
            Do
              If pressed=escape Then done=1
               Else Call Sound 40,.5
            End
           Else           
            Do
              scancode=Right(pressed,1)
              Select
                When scancode=pgup Then
                  Do
                    ok=1
                    If probase=2 Then Call Sound 200,.1
                     Else probase=probase-23
                  End
                When scancode=pgdn Then
                  Do
                    ok=1
                    If probase>=(t-23) Then Call Sound 1300,.1
                     Else 
                      Do
                        probase=probase+23
                        If (probase+24)>t Then probase=t-23
                      End
                  End
                When scancode=homekey Then 
                  Do
                    ok=1
                    If probase=2 Then Call Sound 200,.1
                     Else probase=2
                  End
                When scancode=endkey Then 
                  Do
                    ok=1
                    If probase=t-23 Then Call Sound 1300,.1
                     Else probase=t-23
                  End
                When scancode=helpf1 Then 
                  Do
                    Call ShowHelp
                  End
                Otherwise Call Sound 40,.5
              End  /* select */
              If probase<2 Then probase=2
            End              
        End  /* display text */
        help=0
        Call W_Close temp
      End  /* parsed ok */
     Else Call PopUp 'Failed to find valid Profile info.',5,'X'
  End  /* received ok */
Call ScrWrite 1,1,Center('Article text:',80),,,31
Return


ShowHeader:
Procedure Expose (global) loadsdir
Parse Arg aserial
Call FileRead loadsdir'H'aserial'.TXT','head.'
max=5+head.0
temp=W_Open(2,1,max,80,112)
Call W_ScrWrite temp,max-2,1,Center('(Press any key to dismiss header text.)',80)
Call W_ScrWrite temp,max,1,Copies(':',80)
Do line=1 To head.0
  Call W_ScrWrite temp,1+line,1,head.line
End
Call InKey
Call W_Close temp
Return


SaveIt:
Procedure Expose (global) loadsdir
Parse Arg serial
temp=W_Open(10,1,7,80,95)
Call W_Border temp
Call W_ScrWrite temp,3,2,Center('Enter the save-file name (or press <Esc> to abort):',78)
saveas=W_Get(temp,5,2,78,,15)
Call W_Close temp
If saveas<>'' Then
  Do
    If ValidName(saveas) Then
      Do
        testdir=Reverse(SubStr(Reverse(FileSpec('Drive',saveas)||FileSpec('Path',saveas)),2))
        If DosIsDir(testdir) Then 
          Do
            'copy /B 'loadsdir'H'serial'.TXT+'loadsdir'A'serial'.TXT 'saveas' >& nul'
            ec=rc
            If ec<>0 Then Call PopUp 'Save failed! (rc='ec')',4,'X'
             Else Call Sound 1200,.1
          End
         Else Call PopUp 'That directory does not exist; not saved.',4,'X'
      End
     Else Call PopUp 'That is not a valid filespec.! (Not saved.)',4,'X'
  End
Call CursorType ,,0
Return


HowFar:
Procedure Expose (global)
Parse Arg oldback
temp=W_Open(10,1,7,80,95)
Call W_Border temp
Do Forever
  Call W_ScrWrite temp,3,2,Center('Enter a Look-Back period in days (or press <Esc> to abort):',78)
  lookback=W_Get(temp,5,11,3,,15)
  If lookback='' Then Leave
  If DataType(lookback)='NUM' Then lookback=Format(lookback,,0)
   Else lookback=0
  If lookback>0 Then Leave
  Call Sound 40,.5
End
Call W_Close temp
Call CursorType ,,0
If lookback='' Then lookback=oldback
Return lookback


PopUp:
Procedure Expose (global)
Parse Arg text,color,mode
If mode='' Then second='Press Y for Yes or any other key for No.'
 Else second='Press any key to continue.'
width=6+Length(text)
If width<46 Then width=46
column=1+((80-width)%2)
Call Sound 600,.2
handle=W_Open(10,column,7,width,(color+8)*16)
Call W_Border handle,1,1,1,1
Call W_ScrWrite handle,3,4,Center(text,width-6)
Call W_ScrWrite handle,5,4,Center(second,width-6)
pressed=Upper(InKey())
Call W_Close handle
Call CursorType ,,0
If pressed<>'Y' Then pressed='N'
Return pressed


GoodBye:
/*  For NNTP stuff.  */
Procedure Expose (global)
Parse Arg socket
Call SendLine 'QUIT',socket
Call ScrWrite 25,1,Center('Logging off 'poster'.',80),,,31
got=GetALine(socket)
got=SockSoClose(socket)
If got=-1 Then Call PopUp 'Error closing socket.',4,'X'
Return got


/*------Help Screens:-------------------------------------*/

ShowHelp:
Procedure Expose (global)
temp=W_Open(2,1,24,80,31)
Call W_Border temp
Call W_ScrWrite temp,24,2,Center('(Press any key to dismiss this help screen.)',78,'')
Select
  When help=1 Then
    Do
      Call W_ScrWrite temp, 4,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 5,2,Center('to see more choices (if there are more).',78)
      Call W_ScrWrite temp, 9,2,Center('Press "A" to begin a cross-group search for',78)
      Call W_ScrWrite temp,10,2,Center('all messages containing one or more phrases you will specify.',78)
      Call W_ScrWrite temp,14,2,Center('Press any other letter shown to see',78)
      Call W_ScrWrite temp,15,2,Center('your groups list for that interest cluster.',78)
      Call W_ScrWrite temp,19,2,Center('Press the <Esc> key to exit this program.',78)
    End
  When help=2 Then
    Do
      Call W_ScrWrite temp, 6,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 7,2,Center('to see more choices (if there are more).',78)
      Call W_ScrWrite temp,11,2,Center('Press any letter shown to see',78)
      Call W_ScrWrite temp,12,2,Center('the current articles list for that group.',78)
      Call W_ScrWrite temp,16,2,Center('Press the + key to change the LookBack period in days.',78)
      Call W_ScrWrite temp,19,2,Center('Press the <Esc> key to select another interest cluster of groups.',78)
    End
  When help=3 Then
    Do
      Call W_ScrWrite temp, 6,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 7,2,Center('to see more choices (if there are more).',78)
      Call W_ScrWrite temp,12,2,Center('Press any letter shown to see that specific article.',78)
      Call W_ScrWrite temp,17,2,Center('Press the <Esc> key to select another group in this interest cluster.',78)
    End
  When help=4 Then
    Do
      Call W_ScrWrite temp, 6,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 7,2,Center('to see more choices (if there are more).',78)
      Call W_ScrWrite temp,12,2,Center('Press any letter shown to see that specific article.',78)
      Call W_ScrWrite temp,17,2,Center('Press the <Esc> key to return to selecting interest clusters.',78)
    End
  When help=5 Then
    Do
      Call W_ScrWrite temp, 3,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 4,2,Center('to see more text (if there is more).',78)
      Call W_ScrWrite temp, 6,2,Center('You can use the LeftArrow and RightArrow cursor keys.',78)
      Call W_ScrWrite temp, 7,2,Center('to shift the display sideways if text is off-screen.',78)
      Call W_ScrWrite temp, 9,2,Center('Press Alt-F to see the next article in the articles list.',78)
      Call W_ScrWrite temp,11,2,Center('Press Alt-B to see the previous article in the articles list.',78)
      Call W_ScrWrite temp,13,2,Center('Press Alt-R to post a reply to this article.',78)
      Call W_ScrWrite temp,15,2,Center('Press Alt-P to post a new article in this newsgroup.',78)
      Call W_ScrWrite temp,17,2,Center('Press Alt-H to see the header information for this article.',78)
      Call W_ScrWrite temp,19,2,Center('Press Alt-S to save this article/header to a specific file.',78)
      Call W_ScrWrite temp,22,2,Center('Press the <Esc> key to return to selecting articles.',78)
    End
  When help=6 Then
    Do
      Call W_ScrWrite temp, 8,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 9,2,Center('to see more text (if there is any more).',78)
      Call W_ScrWrite temp,16,2,Center('Press the <Esc> key to return to the original article.',78)
    End
  Otherwise
    Do
      Call W_ScrWrite temp,12,2,Center('No context-sensitive help is available for this screen.',78)
    End
End
Call InKey
Call W_Close temp
Return


/*------Exit Routines:------------------------------------*/

SYNTAX:
which=rc
where=sigl
Do 3
  Call Sound 500,.2
  Call Sound 200,.1
End
Call ScrWrite 11,1,Center('A SYNTAX Trap was Signalled from Line 'where'.',80),,,79
Call ScrWrite 12,1,Center('The Error Number is: 'which', which means:',80),,,15
Call ScrWrite 13,1,Center(ErrorText(which),80),,,2
Call ScrWrite 14,1,Center('Operation cannot continue--press any key to exit.',80),,,79
Call Inkey
Call ItQuits 'Syntax Error 'which' on Line 'where'; type HELP REX'which' for details.',-1


HALT:
where=sigl
Do 3
  Call Sound 500,.2
  Call Sound 200,.1
End
Call ScrWrite 12,1,Center('A HALT was Signalled while in Line 'where'.',80),,,79
Call ScrWrite 13,1,Center('Operation cannot continue--press any key to exit.',80),,,79
Call Inkey
Call ItQuits 'HALT initiated while on Line 'where'.',-2


ItQuits:
Procedure Expose (global)
Parse Arg message,ec
Call CursorType ,,1
If rexxsock Then Call SockDropFuncs
If quercuswin Then Call W_Deregister
Call Sound 400,.2
Call Sound 200,.1
If quercuslib Then Call RexxLibDeregister
If rexxutils Then Call SysDropFuncs
'cls'
Say
Say '   'message
Say
Say
Exit ec


/* [end] */
