#ifndef _ARRAYSTAT_
#define _ARRAYSTAT_

// status value, set in constructor or using Reset
//
const int ARRSTAT_INVALID_COUNT = 1;
const int ARRSTAT_NO_PROBLEM = 0;

// A class for computing statistics of a double precision
// array.
class ArrayStatistics {
	private:
		double minimum;
		double maximum;
		double mean;
		int min_occurred_at;
		int max_occurred_at;
		int status;
	public:
		ArrayStatistics( double *array, int narray );
		int Reset( double *array, int narray );
		double Minimum() { return(minimum); }
		double Maximum() { return(maximum); }
		double Mean() { return(mean); }
		int MinOccurredAt() { return(min_occurred_at); }
		int MaxOccurredAt() { return(max_occurred_at); }
		int Status() { return(status); }
};

#endif