/* REXX **********************************************/
/*                                                   */
/* Name.......: SqrRoot.CMD                          */
/* Function...: Test Rexx algorithms for the Square  */
/*              Root Evolution                       */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg _digit

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( SQUARE ROOT EVOLUTION )", 80, '*')

/*--------------(Test Square Root)---------------*/
If DataType( _digit, 'N' ) = 1 Then
  Say Left("Sqrt("_digit")", 10) "=" SqrRoot(_digit)

Call RandomStem

Do i = 1 To stem.0
  Say Left("Sqrt("stem.i")", 10) "=" SqrRoot(stem.i)
End

Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)===============*/
/*====================(Square root)====================*/
/* :-)                                               6 */
/* Name.......: SqrRoot                                */
/*                                                     */
/* Function...: Square root evolution for the call     */
/*              parameter                              */
/* Call parms.: Evolution number, precision            */
/* Returns....: Square root                            */
/*                                                     */
/* Syntax.....: sqrt = SqrRoot(number, [precision])    */
/*                                                     */
/* Notes......: precision is the highest possible      */
/*              error for the evaluation.              */
/*              Default Value is 0.00001               */
/*              You are responsible for the valid      */
/*              number value                           */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/* (C) Copyright Janosch R. Kowalczyk, 1996.           */
/* All rights reserved.                                */
/*=====================================================*/
SqrRoot: Procedure

Arg number, precision

If Datatype(number) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.000001

sqrt = 1
 
Do Until Abs(sqrt_old - sqrt) < precision
  sqrt_old = sqrt
  sqrt = (sqrt_old * sqrt_old + number) / (2 * sqrt_old)
End /* Do Until ... */

Return sqrt



/*===========(Fill stem with random numbers)=========*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 10)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If DataType(number) \= 'NUM' Then number = 10
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
End

Return ''


