/* REXX **********************************************/
/*                                                   */
/* Name.......: BiSearch.CMD                         */
/* Function...: Test Rexx algorithms for the Binary  */
/*              search                               */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg Sound_File

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( PLAY DIGITAL FILE )", 80, '*')

/*------------(Test Digital Player)--------------*/
rc = RxFuncAdd('mciRxInit','MCIAPI','mciRxInit')
Init_RC = mciRxInit()

/* Adjust following file name */
If Sound_File = '' Then
  Sound_File = 'D:\MMOS2\SOUNDS\STARTUP.WAV'
Say 
Say 'Sound file:' Sound_File 'is played. Please wait for the end.'

rc = PlayFile(Sound_File)
Call mciRxExit

Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
  Call mciRxExit
Exit



/*===============(Internal subroutines)===============*/

/*================(Play digital file)================*/
/* :-)                                OS/2 Only!!! 7 */
/* Name.......: PlayFile                             */
/*                                                   */
/* Function...: Play digital WAV/MID file            */
/*                                                   */
/* Call parms.: File name to play                    */
/* Returns....: RC from the last mciRexx function    */
/*                                                   */
/* Sample call: rc = PlayFile('bach.mid')            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/*===================================================*/
PlayFile: Procedure

Arg CmdObject
If CmdObject = '' Then Return -1

loudness = 70 /* % */
/*--------------(Prepare MCI-commands)---------------*/
CmdStr.1 = 'OPEN' CmdObject 'ALIAS W WAIT'
CmdStr.2 = 'SET W TIME FORMAT MS WAIT'
CmdStr.3 = 'SET W AUDIO VOLUME' loudness 'WAIT'
CmdStr.4 = 'PLAY W WAIT'
/*------------(Play digital WAV/MID file)------------*/
Do i = 1 To 4
  /*-----------(Send MCI command strings)------------*/
  rc = mciRxSendString(CmdStr.i, 'retstrvar', '0','0')
  If rc > 0 Then Leave
End

CmdStr = 'CLOSE W WAIT'
/*--------------(Send MCI command string)--------------*/
rc = mciRxSendString(CmdStr, 'retstrvar', '0','0')

Return rc

