/* REXX *********************************************/
/* Frame for your Rexx program. Verify please!      */
/* Program name: NoUmlaut                           */
/* Function    : Translate the umlauts to double    */
/*             : bytes character string (ae, oe,    */
/*             : ue, ss)                            */
/* Syntax      :                                    */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  20 Dec 1996 / 10:33:16   JRK */
/****************************************************/
Parse Arg string

/*==============(Exception handling)================*/
Signal On Failure Name CLEANUP
Signal On Halt    Name CLEANUP
Signal On Syntax  Name CLEANUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( EXCLUDE MULTIPLE ITEMS )", 80, '*')

If Verify( string, '', 'M' ) = 0 Then
  string = '1 2 3 4 5 6 7'

Say "NoUmlaut('"String"')    -->" NoUmlaut( string )
Say "NoUmlaut('"String"', U) -->" NoUmlaut( string, 'U' )
Say
string = 'Jrg-Gnter Mei'
Say "NoUmlaut('"String"')    -->" NoUmlaut( string )
Say "NoUmlaut('"String"', U) -->" NoUmlaut( string, 'U' )
Say
/*================(End this program)================*/
Call CharOut , "Press any key to exit "
Call LineIn

Exit

CLEANUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/******************************************************/
/*          PROCEDURES                                */
/******************************************************/
/*============( Remove umlaut characters )============*/
/*                                                 14 */
/* Name.......: NoUmlaut                              */
/*                                                    */
/* Function...: Replace umlaut characters with double */
/*              character strings ( -> ae,  -> oe,  */ 
/*               -> ue,  -> ss)                     */
/*                                                    */
/* Call parm..: _string - string with umlauts,        */
/*              _upper  - upper case return string    */
/*                        (optional)                  */
/*                                                    */
/* Returns....: translated string                     */
/*                                                    */
/* Syntax.....:                                       */
/*    tranStr = NoUmlaut( uString,['U'] )             */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Note.......: This function calls the function      */
/*              ReplaceUmlaut                         */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk, 1996.           */
/*====================================================*/
NoUmlaut: Procedure
Parse Arg _string, _upper

/*---------(Replace '' '' by 'ae' 'Ae')-----------*/
_string = ReplaceUmlaut( _string, '', 'ae' )
_string = ReplaceUmlaut( _string, '', 'Ae' )

/*---------(Replace '' '' by 'oe' 'Oe')-----------*/
_string = ReplaceUmlaut( _string, '', 'oe' )
_string = ReplaceUmlaut( _string, '', 'Oe' )

/*---------(Replace '' '' by 'ue' 'Ue')-----------*/
_string = ReplaceUmlaut( _string, '', 'ue' )
_string = ReplaceUmlaut( _string, '', 'Ue' )

/*-------------(Replace '' by 'ss')----------------*/
_string = ReplaceUmlaut( _string, '', 'ss' )

If Abbrev('UPPER', _upper, 1) = 1 Then
  Return Translate( _string )

Return _string

/*========( Replace a string with an another )========*/
/*                                                    */
/* Name.......: ReplaceUmlaut                         */
/*                                                    */
/* Function...: Find all occurences of a substring    */
/*              and replace it by an another          */
/*                                                    */
/* Call parm..: _string  - input string,              */
/*              _origin  - substring to be replaced   */
/*              _replStr - replace substring          */
/*                                                    */
/* Returns....: translated string                     */
/*                                                    */
/* Syntax.....:                                       */
/*    tranStr = ReplaceUmlaut( String, origin, repl ) */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/* Note.......: This function is called from NoUmlaut */
/*              and was developed for this purpose    */
/*              only. It isn't able to replace sub-   */
/*              strings that have same characters in  */
/*              both - origin and replace string!     */
/*                                                    */
/* Author.....: Janosch R. Kowalczyk, 1996.           */
/*====================================================*/
ReplaceUmlaut: Procedure
Parse Arg _string, _origin, _replStr

/*---( Same characters in the input and output strings )---*/
If Verify( _origin, _replStr, 'M' ) > 0 Then Return _string

/*-----(Replace umlaut by combined characters)-----*/
Do While Pos( _origin, _string ) > 0
  Parse Var _string _prefix_ (_origin) _suffix_
  _string = _prefix_ || _replStr || _suffix_
End

Return _string
