/* REXX *********************************************/
/* Frame for your Rexx program. Verify please!      */
/* Program name: Combine                            */
/* Function    : Format a string with the interval  */
/* Syntax      :                                    */
/* Changes     :                                    */
/*                                                  */
/* (C) Copyright Janosch R. Kowalczyk, 1996.        */
/* All rights reserved.                             */
/* Made use of GREED.  19 Dec 1996 / 13:29:02   JRK */
/****************************************************/
Parse Arg arg1, arg2
/* trace ?r */
/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

text = 'Test for COMBINE external function'
Say Combine( text, Length(text) )
text = '                                  '
Say Combine( text, Length(text), '_' )
Say
Say '1. Possibilities:'
text = XRange('A', 'X')
Say 'Input :' text
Say 'Output:' Combine( text, Length(text), , 4 )
Say 'Output:' Combine( text, Length(text), ' * ', 2 )
Say 'Output:' Combine( text, Length(text), ' centre ', Length(text)/2 )
Say 'Output:' Combine( text, Length(text), ' third ', Length(text)/3 )
text = '1334567892134'
Say 'Input :' text
Say 'Output:' Combine( text, Length(text), '.', 3 )
text = '10000000000000000'
Say 'Input :' text
Say 'Output:' Combine( text, Length(text), '.', 3 )
text = '10000000000000000'
Say 'Output:' Combine( text, Length(text), ',', 3 )
Say

text = '*****'
Say Center(Combine( text, Length(text), '  ' ), 60)
Say
Say '2. Samples for practical using:'
text = '13456783934566212'
Say 'Input :' text
text = Combine( text, Length(text), '+' )
Interpret 'y = 'text
Say 'Output:' text '=' y
text = '4216783'
Say 'Input :' text
text = Combine( text, Length(text), ' * ' )
Interpret 'y = 'text
Say 'Output:' text '=' y
Say

Call LineOut , 'Press any key to exit '
Call CharIn

/*================(End this program)================*/
Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*====================( Format a string )===================*/

Combine: Procedure
Parse Arg _combStr, _combLen, _combTooth, _combRep

/*-------(End processing and return formated string)--------*/
If _combLen < 1 | DataType(_combLen, 'N') = 0 Then
  Return _combStr

/*------(Check call parameter and set default values)-------*/
_combLen = Trunc( _combLen )

If _combTooth = '' Then
  _combTooth = ' '

If _combRep < 1 | DataType(_combRep, 'N') = 0 Then
  _combRep = 1
Else If _combRep >= _combLen Then
  Return _combStr

_combRep = Trunc( _combRep )

/*------------(Set new value for Insert position)-----------*/
_combLen = _combLen - _combRep

/*------------(Call recursive for the naxt step)------------*/
Return Combine( Insert( _combTooth, _combStr, _combLen ),,
                _combLen,,
                _combTooth,,
                _combRep )
