/* REXX **********************************************/
/*                                                   */
/* Name.......: BubSort.CMD                          */
/* Function...: Test Rexx algorithms for the Bubble  */
/*              sort                                 */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Notes......: Start this file with PMREXX to see   */
/*              the output lines.                    */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/
Arg _items

/*===============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Say 
Say Center( "( BUBBLE SORT )", 80, '*')

/*--------------(Set random numbers)-------------*/
Call RandomStem _items

/*-----------------(Bubble Sort)-----------------*/
Say "Following values will be sorted:"
Say
Say SayStem()
Say
Say "Test Bubble Sort."
start = Time(r)

Call BubSort

endTime = Time(r)
Say "Sort duration for" stem.0 "digits:" endTime "sec."
Say
Call LineOut , "Press any key to continue "
Call LineIn

/* Following 3 statements can be comment out */
Say "Following values have been sorted:"
Say SayStem()
Say

Say "Sort duration for" stem.0 "digits:" endTime "sec."
Say
Call LineOut , "Press any key to exit "
Call LineIn

Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*===============(Internal subroutines)==============*/

/*===================(Bubble sort)===================*/
/* :-I                                               */
/* Name.......: BubSort                              */
/*                                                   */
/* Function...: Bubble Sort for a stem variable      */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call BubSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

BubSort: Procedure Expose stem.

/*------------(Bubble Sort for the Stem)-------------*/
Do i = stem.0 To 1 By -1 Until flip_flop = 1
  flip_flop = 1
  Do j = 2 To i
    m = j - 1
    If stem.m > stem.j Then Do
      xchg   = stem.m
      stem.m = stem.j
      stem.j = xchg
      flip_flop = 0
    End /* If stem.m ... */
  End /* Do j = 2 ...    */
End /* Do i = stem.0 ... */

Return ''


/*===========(Fill stem with random numbers)=========*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 50)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If DataType(number) \= 'NUM' Then number = 50
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
End

Return ''


/*===============( Say stem as one line )============*/
/*                                                   */
/* Name.......: SayStem                              */
/*                                                   */
/* Function...: Says stem as one line with delimiter */
/*                                                   */
/* Call parm..: Delimiter character(s) (default: ',')*/
/*              Prefix for return value (dflt. : '') */
/*                                                   */
/* Returns....: Line with all stems                  */
/*                                                   */
/* Syntax.....: stemLine = SayStem [delim][, prefix] */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
SayStem: Procedure Expose stem.

Parse Arg _delim, _stemLine

If _delim = '' Then _delim = ','

If stem.0 > 0 Then _stemLine = stem.1

Do i = 2 To stem.0
  _stemLine = _stemLine || _delim || stem.i
End /* End Do ... */

Return _stemLine