Listing 2: WinThread.h
--------------------------------------------------------------------------
// WinThread.h - Win32-specific
// AThread declaration

#ifndef _WINTHREAD_
#define _WINTHREAD_
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "AThread.h"

class AWinThread : public AThread {
public:
   AWinThread();
   virtual ~AWinThread();

   void SetDeadState() { mState = DEAD; }
   virtual void Kill(BOOL force = FALSE);

   static DWORD __stdcall EntryPoint(void* par);

protected:
   HANDLE mThread;
   CRITICAL_SECTION mHandleLock;

   virtual void LockHandle()
      { ::EnterCriticalSection(&mHandleLock); }
   virtual void UnlockHandle()
       { ::LeaveCriticalSection(&mHandleLock); }

   virtual void CheckStatus();
};

#endif
