Listing 3: WinThread.cpp
--------------------------------------------------------------------------
// WinThread.cpp - Win32
// multithreading implementation

#include "WinThread.h"

DWORD __stdcall AWinThread::EntryPoint(void* p) {
   AWinThread* ptr = (AWinThread*) p;
   ptr->Run();
   ptr->SetDeadState();
   return 0;
}

AWinThread::AWinThread() {
   DWORD ptr;

   ::InitializeCriticalSection(&mHandleLock);
   mThread = ::CreateThread(NULL, 0, EntryPoint,
      (LPVOID)this, CREATE_SUSPENDED, &ptr);

   if (mThread == NULL) mState = DEAD;
   else {
      mState = RUN;
      ::ResumeThread(mThread);
   }
}

AWinThread::~AWinThread() {
   if (mState != DEAD) Kill(TRUE);
   ::DeleteCriticalSection(&mHandleLock);
}

void AWinThread::Kill(BOOL force) {
   LockHandle();
   if (mThread) {
      if (force) {
         ::TerminateThread(mThread, 0);
         mState = DEAD;
         mThread = NULL;
      }
      else mState = TERMINATE;
   }
   UnlockHandle();
}

void AWinThread::CheckStatus() {
   LockHandle();
   if (mState == TERMINATE) {
      mState = DEAD;
      mThread = NULL;
      UnlockHandle();
      ::ExitThread(0);
   }
   UnlockHandle();
}
