Listing 4: UNIXThread.h
--------------------------------------------------------------------------
// UNIXThread.h - UNIX-specific
// AThread declaration

#ifndef _POSIXTHREAD_
#define _POSIXTHREAD_
#include <pthread.h>
#include "AThread.h"

class AUNIXThread : public AThread {
public:
   AUNIXThread();
   virtual ~AUNIXThread();

   void SetDeadState() { mState = DEAD; }

   virtual void Kill(BOOL force = FALSE);

   static void EntryPoint(void* param);

protected:
   pthread_t mThread;
   pthread_mutex_t mHandleLock;

   virtual void LockHandle()
      { pthread_mutex_lock(&mHandleLock); }
   virtual void UnlockHandle()
      { pthread_mutex_unlock(&mHandleLock); }

   virtual void CheckStatus();
};

#endif
