/* ============ */
/* getextch.h	*/
/* ============ */
# if defined(__GETEXTCH_H__)
#	/* Do Nothing */
# else
#	define	__GETEXTCH_H__
#define	QFLT
#include <stdio.h>
#include <stdlib.h>
//#include <math.h>
#include <qfloat.h>
#include "machars.h"
/* Get machine characteristics - after P.J. Plauger in elefunt */
/* ======================================================================= */
/* GetExtCh - Determines Extended-Precision Floating-Point Characteristics */
/* ======================================================================= */
MACHAR_STRU
GetExtCh(void)
{
    short        k, n;
    const
    qfloat	 Zero = 0.0, One = 1.0;
    qfloat	 T0, T1, T2;
    MACHAR_STRU  MachData;

    printf("Determine Extended-Precision "
	   "Floating-Point Characteristics\n");

//printf("Determine Radix\n");
    /* --------------- */
    /* Determine Radix */
    /* --------------- */
    for (T1 = One + One; ; T1 += T1)
    {
	/* ----------------------------------- */
	/* Scale T1 Until Can't See Adding One */
	/* ----------------------------------- */
	T0 = T1 + One;
	T0 -= T1;
	if (T0 - One != Zero)
	    break;
    }
    for (T2 = One + One;; T2 += T2)
    {
	/* ------------------------------------- */
	/* Scale T2 Until Can't See Adding to T1 */
	/* ------------------------------------- */
	T0 = T1 + T2;
	if (T0 - T1 != Zero)
	    break;
    }
    MachData.Radix = (short)xtold (T1 + T2 - T1);

//printf("Determine No. Digits in Fraction\n");
    /* -------------------------------- */
    /* Determine No. Digits in Fraction */
    /* -------------------------------- */
    T1 = (qfloat) MachData.Radix;
    for (MachData.FracDigs = 1;; ++(MachData.FracDigs))
    {
	T0 = T1 + One;
	T0 -= T1;
	if (T0 - One != Zero)
	    break;

	T1 *= (qfloat) MachData.Radix;
    }

//printf("Determine Whether Floating Point Addition Chops or Rounds\n");

    /* -------------------------------- */
    /* Determine Whether Floating Point */
    /* Addition Chops (0) or Rounds (1) */
    /* -------------------------------- */
    for (T1 = One + One; ; T1 += T1)
    {
	/* ----------------------------------- */
	/* Scale T1 Until Can't See Adding One */
	/* ----------------------------------- */
	T0 = T1 + One;
	T0 -= T1;
	if (T0 - One != Zero)
	    break;
    }

    T2 = (qfloat) MachData.Radix * 2 - One;

    if ((T1 + T2) - T1 > T2)
	MachData.Rounds = 1;
    else
	MachData.Rounds = 0;

//printf("Determine EpsNeg\n");
    /* ---------------- */
    /* Determine EpsNeg */
    /* ---------------- */
    for (T1 = One, k = 0; k < MachData.FracDigs + 3; ++k)
	T1 = T1 * One / (qfloat) MachData.Radix;

    /* ---------------------------- */
    /* loop until EpsNeg big enough */
    /* ---------------------------- */
    for (;; T1 = T1 * (qfloat) MachData.Radix)
    {
	T0 = One - T1;
	if (T0 - One != Zero)
	    break;
    }
    MachData.EpsNeg = T1;

//printf("Determine Eps\n");
    /* ------------- */
    /* Determine Eps */
    /* ------------- */
    for (T1 = One, k = 0; k < MachData.FracDigs + 3; ++k)
	T1 = T1 * One / (qfloat) MachData.Radix;

    /* ------------------------- */
    /* Loop Until Eps Big Enough */
    /* ------------------------- */
    for (;; T1 = T1 * (qfloat) MachData.Radix)
    {
	T0 = One + T1;
	if (T0 - One != Zero)
	    break;
    }
    MachData.Eps = T1;

//printf("Determine No. Guard Digits Used in Multiplication\n");
    /* -------------------------- */
    /* Determine Number of Guard  */
    /* Digits Used Multiplication */
    /* -------------------------- */
    MachData.NumGuard = 0;
    if (MachData.Rounds == 0 &&
	(One + MachData.Eps) * One - One != Zero)
	MachData.NumGuard = 1;

//printf("Determine No. ExpDigits\n");
    /* --------------------------------------------- */
    /* Determine ExpDigits, MaxExp, MinExp, Max, Min */
    /* --------------------------------------------- */
    /* ------------------------ */
    /* Count Digits in Exponent */
    /* ------------------------ */
    T0 = One / (qfloat) MachData.Radix;
    T1 = T0;
    for (k = 2; ; ++k)
    {
	T1 *= T0;
	if (T1 == 0)
	    break;
    }

//printf("Determine MaxExp\n");
    /* ---------------- */
    /* Maximum Exponent */
    /* ---------------- */
    MachData.MaxExp = k;

    for (n = 1; k > 0; k >>= 1)
	++n;

    MachData.ExpDigits = n;

//printf("Determine Max Flt\n");
    /* ----------------------------- */
    /* Maximum Floating Point Number */
    /* ----------------------------- */
    MachData.Max = (One - MachData.EpsNeg) * 2;
//xprintf("First Max = ", MachData.Max, 11, "\n");

    for (k = 1; k <= MachData.MaxExp; ++k)
    {
	MachData.Max *= MachData.Radix;
    }
//xprintf("Last  Max = ", MachData.Max, 11, "\n");
//printf("Determine Min Flt\n");
    /* ----------------------------- */
    /* Minimum Floating Point Number */
    /* ----------------------------- */
    T2 = One / MachData.Radix;;
//xprintf("T2 = ", T2, 11, "\n");
    for (n = 1; ; ++n)
    {
	MachData.Min = T2;
	/* ------------------------- */
	/* Scale Min Until Underflow */
	/* ------------------------- */
	T2 *= One / MachData.Radix;
//xprintf("T2 = ", T2, 11, ", ");
	T0 = T2 * One;
//xprintf("T0 = ", T0, 11, "\n");

	if (T0 + T0 == Zero)
	    break;
    }
//printf("Determine MinExp\n");
    /* ---------------- */
    /* Minimum Exponent */
    /* ---------------- */
    MachData.MinExp = (short)(-n);

    return MachData;
}
# if defined(TEST_EXTCH)
void
main()
{
    MACHAR_STRU MachData;

    MachData = GetExtCh();

    printf("Radix                  = %d\n"
	   "Fraction Digits        = %d\n"
	   "No. Mult. Guard Digits = %d\n",
	MachData.Radix,
	MachData.FracDigs,
	MachData.NumGuard);
    printf("ExpDigits              = %d\n"
           "MaxExp                 = %d\n"
	   "MinExp                 = %d\n",
	   MachData.ExpDigits,
	   MachData.MaxExp,
	   MachData.MinExp);
    printf("\nFloating Point Addition %ss\n\n",
	(MachData.Rounds) ? "Round" : "Chop");
    xprintf("Eps                 = ",
	MachData.Eps,    10, "\n");
    xprintf("EpsNeg              = ",
	MachData.EpsNeg, 10, "\n");
    xprintf("Max (Largest F.P.)  = ", MachData.Max, 10, "\n");
    xprintf("Min (Smallest F.P.) = ", MachData.Min, 10, "\n");
}
# endif			/* TEST_EXTCH	  */
# endif			/* __GETEXTCH_H__ */
