/* ======== */
/* xvsqrt.h */
/* ======== */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN   xsqrt
#define TST_FUN   NAME(sqrt)
// ----------------------
// Natural logarithm of 2
// ----------------------
static	const	qfloat	LOG2 = "0.69314718055994530941"
			       "72321214581765680755";
// -----------------------------------|
// f1 - sqrt versus xsqrt over (.5, 1)|
// -----------------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    // Calculate Logarithmically Distributed Argument
    FunArg = (TYPE)xtold(.5*xexp(x*LOG2));

    pzz = EXT_FUN(FunArg);

    return NAME(sqrt)(FunArg);
}
// ----------------------------------|
// f2 - sqrt versus xsqrt over (1, 2)|
// ----------------------------------|
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    // Calculate Logarithmically Distributed Argument
    FunArg = (TYPE)xtold(xexp(x*LOG2));

    pzz = EXT_FUN(FunArg);

    return NAME(sqrt)(FunArg);
}
/* ==================================================================== */
/* main - Compares standard sqrt function with extended version		*/
/* ==================================================================== */
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    const
    char	*FunStr = MAK_STR(TST_FUN);
    char	 Label[128];
    TYPE	 TestArg, TestAns;
    qfloat	 HiLim, LoLim;
    MACHAR_STRU  MachData;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);
    MachData = GetMachar();

    printf("There are %d Base %d Significant Digits\n",
	MachData.FracDigs, MachData.Radix);

    HiLim = 1.0;
    LoLim = (qfloat)1.0/(qfloat)MachData.Radix;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 1,
	FunStr, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = HiLim;
    HiLim = MachData.Radix;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 2,
	FunStr, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    printf("\nSPECIAL VALUES:\n");

    printf("\nThese calls should not "
	   "trigger error messages\n");
    TestArg = (TYPE)0.0;
    TestAns = NAME(sqrt)(TestArg);
    if (TestAns == TestArg)
    {
	printf("\t%s(0) = 0 (Exactly)\n", FunStr);
    }
    else
    {
	printf("\t%s(0) Failed = %.20LG\n",
		FunStr, (LDBL)TestAns);
    }
    TestArg = (TYPE)1.0;
    TestAns = NAME(sqrt)(TestArg);
    if (TestAns == TestArg)
    {
	printf("\t%s(1) = 1 (Exactly)\n", FunStr);
    }
    else
    {
	printf("\t%s(1) Failed = %.20LG\n", FunStr,
		(LDBL)TestAns);
    }
    printf("\n\tEpsNeg = %.20LG\n",
	(long double)MachData.EpsNeg);

    TestArg = (TYPE)1.0 - MachData.EpsNeg;
    TestAns = NAME(sqrt)(TestArg);
    if (TestAns == (TYPE) 1.0)
    {
	printf("\t%s(1 - EpsNeg) = 1 (Exactly)\n",
		FunStr);
    }
    else
    {
	printf("\t%s(1 - EpsNeg) = %.20LG\n",
		FunStr, (long double)TestAns);
    }
    printf("\n\tEps    = %.20LG\n",
	(long double)MachData.Eps);

    TestArg = (TYPE) 1.0 + MachData.Eps;
    TestAns = NAME(sqrt)(TestArg);
    if (TestAns == (TYPE) 1.0)
    {
	printf("\t%s(1 + Eps) = 1 (Exactly)\n",
		FunStr);
    }
    else
    {
	printf("\t%s(1 + Eps) = %.20LG\n",
		FunStr, (long double)TestAns);
    }

    TestArg = MachData.Min;
    printf("\n\tMin = %.20LG\n", (LDBL)TestArg);

    TestAns = NAME(sqrt)(TestArg);
    printf("\t%s(Min) = %.20LG\n", FunStr, (LDBL)TestAns);

    TestArg = MachData.Max;
    printf("\n\tMax = %.20LG\n", (LDBL)TestArg);

    TestAns = NAME(sqrt)(TestArg);
    printf("\t%s(Max) = %.20LG\n", FunStr, (LDBL)TestAns);

    {
	int	FailCt = 0;
	printf("\nTesting x = %s(x*x) for integral "
		"x in [1, %d]\n", FunStr, TEST_SIZE);
	for (TestArg = 1; TestArg <= TEST_SIZE; ++TestArg)
	{
		TestAns = NAME(sqrt)(TestArg*TestArg);
		if (TestArg != TestAns)
		{
		   ++FailCt;
		}
	}
	printf("\n\tx = %s(x*x) failed %d out of %.Lf times\n",
		FunStr, FailCt, (LDBL)(TestArg-1));
    }

    printf("\nBOUNDARY VALUE:\n");
    printf("\tFinding Square Root of "
	   "a Negative Number:\n");
    printf("\n\tThis call might trigger "
	   "an error message\n");

    fflush(NULL);
    TestAns = NAME(sqrt)((TYPE)-1.0);

    fflush(NULL);
    printf("\tResult: %s(-1.0) = %LG\n",
	FunStr, (LDBL) TestAns);

    return (0);
}
