/* ======= */
/* xvsin.h */
/* ======= */
// After Cody & Waite and Plauger
#include "xverfun.h"
// ---------------------
// sin(x) versus xsin(x)
// ---------------------
static
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    SinArg;

    SinArg = (TYPE)xtold(x);

    pzz = xsin(SinArg);

    return NAME(sin)(SinArg);
}
// ---------------------
// cos(x) versus xcos(x)
// ---------------------
static
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    CosArg;

    CosArg = (TYPE)xtold(x);

    pzz = xcos(CosArg);

    return NAME(cos)(CosArg);
}
// -------------------------------------------------------------
// Main Program to Test sin/cos Function versus Extended sin/cos
// -------------------------------------------------------------
static const TYPE PI = 3.141592653589793238462643383279502884L;

#define	MAK_STR(x)	STR_NAME(x)
#define	STR_NAME(x)	#x
#define	TEST_FUN_1	NAME(sin)
#define	TEST_FUN_2	NAME(cos)
#define	TEST_SIZE	1000
int
main()
{
    int		 k;
    TYPE	 ArgDelt;
    TYPE	 RadixPow;
    TYPE	 CosArg, CosAns, SinArg, SinAns;
    char	 Label[128];
    const char  *FunStr1 = MAK_STR(TEST_FUN_1);
    const char  *FunStr2 = MAK_STR(TEST_FUN_2);
    MACHAR_STRU  MachData;

    printf("Test of %s(x) vs. xsin(x) & "
	           "%s(x) vs. xcos(x):\n",
	    FunStr1, FunStr2);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%s, %s)", 	FunStr1,
		TEST_SIZE, "0.0", "pi/2");
    XVerFun(MachData, TEST_SIZE, 0, PI/2.L, &f1, Label);

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%s, %s)", 	FunStr2,
		TEST_SIZE, "0.0", "pi/2");
    XVerFun(MachData, TEST_SIZE, 0, PI/2.L, &f2, Label);

    sprintf(Label, "Test 3: %s(x) for %d values in "
		   "(%s, %s)", 	FunStr1,
		TEST_SIZE, "6*pi", "6.5*pi");
    XVerFun(MachData, TEST_SIZE, 6.0L*PI, 6.5L*PI, &f1, Label);

    sprintf(Label, "Test 4: %s(x) for %d values in "
		   "(%s, %s)", 	FunStr2,
		TEST_SIZE, "7*pi", "7.5*pi");
    XVerFun(MachData, TEST_SIZE, 7.0L*PI, 7.5L*PI, &f2, Label);

    printf("\nSPECIAL VALUES:\n\n");
    ArgDelt = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs / 2; ++k)
	ArgDelt /= (TYPE) MachData.Radix;

    SinArg = (TYPE) 6 * (TYPE) PI + ArgDelt;
    SinAns = NAME(sin) (SinArg);
    SinArg = (TYPE) 6 * (TYPE) PI - ArgDelt;
    SinAns -= NAME(sin) (SinArg);
    SinAns /= (ArgDelt + ArgDelt);

    printf("%s(x) has proper period if %.25LE "
	   "is close to 1\n\n", FunStr1, (LDBL) SinAns);

    printf("%s(x) + %s(-x) for random values in "
	   "[0, 6PI)\n", FunStr1, FunStr1);
    for (k = 1; k <= 5; ++k)
    {
	SinArg = (TYPE)(LDURand() *  6.0 * PI);
	SinAns = NAME(sin) (SinArg);
	SinAns += NAME(sin) (-SinArg);

	printf("\tx =%14.10Lf, %s(x) + %s(-x) = %.10LG\n",
	    (LDBL) SinArg, FunStr1, FunStr1, (LDBL) SinAns);
    }

    RadixPow = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	RadixPow *= (TYPE) MachData.Radix;

    RadixPow = (TYPE)(LDURand() / RadixPow);

    printf("\nsin(x) - x for Small x\n");
    for (k = 1; k <= 5; ++k)
    {
	SinAns = NAME(sin)(RadixPow) - RadixPow;
	printf("\tx = %.10LE, %s(x) - x = %.20LG\n",
	    (LDBL) RadixPow, FunStr1,
	    (LDBL) SinAns);

	RadixPow /= (TYPE) MachData.Radix;
    }

    /* cos(x) vs. cos(-x) for random values */

    printf("\n%s(x) - %s(-x) for random values in "
	   "[0, 7PI)\n", FunStr2, FunStr2);
    for (k = 1; k <= 5; ++k)
    {
	CosArg = (TYPE)(LDURand() * 7.0 * PI);
	CosAns = NAME(cos)(CosArg);
	CosAns -= NAME(cos)(-CosArg);

	printf("\tx =%14.10Lf, %s(x) - %s(-x) = %.10LG\n",
	    (LDBL) CosArg, FunStr2, FunStr2, (LDBL) CosAns);
    }
    RadixPow = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	RadixPow /= (TYPE) MachData.Radix;

    SinAns = NAME(sin)(RadixPow);

    fflush(NULL);
    printf("\n\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) RadixPow, FunStr1, (LDBL) SinAns);

    RadixPow = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	RadixPow *= (TYPE) MachData.Radix;

    RadixPow = NAME(sqrt)(RadixPow);

    printf("\n\t%s(x) for consecutive x around %.20LG:\n",
		FunStr1, (LDBL) RadixPow);
    fflush(NULL);

    printf("\nThe following calls should not "
	   "trigger any error messages:\n\n");
    SinArg = RadixPow * ((TYPE) 1 - MachData.Eps);
    SinAns = NAME(sin)(SinArg);
    fflush(NULL);
    printf("\t\t%s(%.10Lf) = %.20LG\n", FunStr1,
	(LDBL) SinArg, (LDBL) SinAns);

    fflush(NULL);
    SinArg = RadixPow;
    SinAns = NAME(sin)(RadixPow);
    fflush(NULL);
    printf("\t\t%s(%.10Lf) = %.20LG\n", FunStr1,
	(LDBL) SinArg, (LDBL) SinAns);
    fflush(NULL);

    SinArg = RadixPow * ((TYPE) 1 + MachData.Eps);
    SinAns = NAME(sin)(SinArg);
    printf("\t\t%s(%.10Lf) = %.20LG\n", FunStr1,
	(LDBL) SinArg, (LDBL) SinAns);
    fflush(NULL);

    printf("BOUNDARY VALUE:\n");
    printf("\nThe following call might "
	   "trigger an error message:\n");
    fflush(NULL);

    RadixPow *= RadixPow;
    SinArg = RadixPow;
    SinAns = NAME(sin)(RadixPow);
    fflush(NULL);
    printf("\t\t%s(%.20LE) = %.10LG\n", FunStr1,
	(LDBL) SinArg, (LDBL) SinAns);

    return (0);
}
