/* ======= */
/* xvpow.h */
/* ======= */
// After Cody & Waite and Plauger
#include "xverfun.h"
#include "xverfun2.h"
// --------------------------------|
// TstFun(x, 1) versus ExtFun(x, 1)|
// --------------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)xtold(x);

    pzz = xpow(FunArg, 1);

    return NAME(pow)(FunArg, 1);
}
// ----------------------------------------|
// TstFun(x*x, 1.5) versus ExtFun(x*x, 1.5)|
// ----------------------------------------|
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)xtold(x*x);	/* Arg^2 */

    pzz = xpow(FunArg, 1.5);

    return NAME(pow)(FunArg, 1.5);
}

qfloat f3 (qfloat x, qfloat y, qfloat &pzz)
{
    TYPE    FunArgX, FunArgY;

    FunArgX = (TYPE)xtold(x);
    FunArgY = (TYPE)xtold(y);

    pzz = xpow(FunArgX, FunArgY);

    return NAME(pow)(FunArgX, FunArgY);
}
// -----------------------------------------------------
// Main Program to Test exp Function versus Extended exp
// -----------------------------------------------------
#define EXT_FUN 	xpow
#define TST_FUN 	NAME(pow)
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int 	    k;
    TYPE	    BasArg, ExpArg, PowAns;
    char	    Label[128];
    const char	   *FunStr = MAK_STR(TST_FUN);
    MACHAR_STRU     MachData;
    qfloat	    Arg1, HiLim, LoLim, MaxExtNum, YRange;

    printf("Test of %s(x,p) vs. %s(x,p):\n", FunStr, EXT_FUN_STR);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = (qfloat)1.0/(qfloat)(MachData.Radix);
    HiLim = (qfloat)1.0;

    sprintf(Label, "Test %d: %s(x,1) for %d values in "
		"(%+.10LG, %+.10LG)", 1,
	FunStr, TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    sprintf(Label, "Test %d: %s(x*x,1.5) for %d values in "
		"(%+.10LG, %+.10LG)", 2,
	FunStr, TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    MaxExtNum = MachData.Max;

    LoLim = (qfloat)1.0;
    HiLim = xexp(xlog(MaxExtNum) / (qfloat)3.0);

    sprintf(Label, "Test %d: %s(x*x,1.5) for %d values in "
		"(%s, %+.5LG)", 3,
	FunStr, TEST_SIZE, "+1.0", xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    LoLim = (qfloat)1.0/(qfloat)100.0, HiLim = 10.0;

    YRange = xlog((qfloat)MachData.Max);
    if (YRange < -xlog((qfloat)MachData.Min))
    {
	YRange = -xlog((qfloat)MachData.Min);
    }

    YRange /= xlog(100);

    sprintf(Label, "Test %d: %s(x,y) for %d values of"
	"\n\tx in (%+.6LG, %+.6LG) and"
	"\n\ty in (%+.6LG, %+.6LG)", 4,
	FunStr, TEST_SIZE, xtold(LoLim), xtold(HiLim),
	-xtold(YRange), xtold(YRange));

    XVerFunXY(MachData, TEST_SIZE, LoLim, HiLim, -YRange, YRange,
	&f3, Label);

    printf("SPECIAL VALUES:\n\n");
    printf("These calls should not trigger"
           " error messages:\n\n");
    printf("\tComparing %s(x, y) vs. %s(1/x, -y)\n"
	   "\tfor Random Values of x & y in [1, 11):\n",
	FunStr, FunStr);
    printf("\t\t\t\t\tRelative\n"
           "\t        x              y\t  Error\n"
           "\t        -              -\t  -----\n");
    /* ------------------------------------- */
    /* The following code is taken virtually */
    /* directly from Plauger's elefunt code. */
    /* ------------------------------------- */
    for (k = 1; k <= 10; ++k)
    {					/* random values */
	TYPE	RelErr, Ans1, Ans2;

	BasArg = (TYPE) LDURand() * (TYPE) 10 + (TYPE) 1;
	ExpArg = (TYPE) LDURand() * (TYPE) 10 + (TYPE) 1;

	Ans1 = NAME(pow)(BasArg, ExpArg);
	Ans2 = NAME(pow)((TYPE) 1 / BasArg, -ExpArg);
	RelErr = (Ans1 - Ans2) / Ans1;

	printf("\t%14.10Lf %14.10Lf %+7.25LG\n",
	    (LDBL) BasArg, (LDBL) ExpArg, (LDBL) RelErr);
    }
    printf("\n");
    BasArg = (TYPE) MachData.Radix;
    ExpArg = (TYPE) (MachData.MinExp - 1);
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %+.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    BasArg = (TYPE) MachData.Radix;
    ExpArg = (TYPE) (MachData.MaxExp -1);
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %+.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    BasArg = (TYPE) 0;
    ExpArg = (TYPE) 2;
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    BasArg = (TYPE) -2;
    ExpArg = (TYPE) 0;
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    BasArg = (TYPE) -2;
    ExpArg = (TYPE) 2;
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    printf("\nBOUNDARY VALUES:\n");
    printf("\n\tThese calls might trigger "
	   "error messages:\n\n");
    fflush(NULL);

    BasArg = (TYPE) -1.25;
    ExpArg = (TYPE) -2.375;
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    BasArg = (TYPE) 0;
    ExpArg = (TYPE) 0;
    fflush(NULL);
    PowAns = NAME(pow)(BasArg, ExpArg);
    fflush(NULL);
    printf("\t%s(%.10LG, %.10LG) = %.10LG\n", FunStr,
	(LDBL) BasArg, (LDBL) ExpArg, (LDBL) PowAns);

    return (0);
}
