/* ======= */
/* xvexp.h */
/* ======= */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN 	xexp
#define TST_FUN 	NAME(exp)
// --------------------------|
// TstFun(x) versus ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg, FunAns;

    FunArg = (TYPE)xtold(x);

    pzz = xexp(FunArg);

    FunAns = NAME(exp)(FunArg);

    return FunAns;
}
// -----------------------------------------------------
// Main Program to Test exp Function versus Extended exp
// -----------------------------------------------------
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int 	    k;
    LDBL	    RadixPow;
    TYPE	    ExpAns, ExpArg;
    char	    Label[128];
    const char	   *FunStr = MAK_STR(TST_FUN);
    MACHAR_STRU     MachData;
    qfloat	    Arg1, HiLim, LoLim, MaxExtNum, Result;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = -(qfloat)0.5 * xlog((qfloat)2);
    HiLim =  (qfloat)0.5 * xlog((qfloat)2);

    sprintf(Label, "Test 1: %s(x) for values in "
	    "(-0.5*log(2), +0.5*log(2))", FunStr);

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    RadixPow = 1;

    for (k = 1; k <= MachData.FracDigs; ++k)
    {
	 RadixPow *= MachData.Radix;
    }
    HiLim = LoLim;
    LoLim = xfloor(xlog((qfloat)(8.0*MachData.Min*RadixPow)));

    sprintf(Label, "Test 2: %s(x) for values in "
		"(%+.5LG, -0.5*log(2))",
		FunStr, xtold(LoLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    HiLim = (qfloat)100.0 * xlog((qfloat)2);

    MaxExtNum = xpow(2, MachData.MaxExp);

    if (MaxExtNum > (qfloat)MachData.Max)
    {
	MaxExtNum = (qfloat)MachData.Max;
    }

    Result = xlog((qfloat)0.99995*MaxExtNum);

    if (HiLim < Result)
    {
	HiLim = Result;
    }

    HiLim = xfloor(HiLim);

    sprintf(Label, "Test 3: %s(x) for values in "
		   "(10*log(2), %+.5LG)",
		    FunStr, xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    printf("SPECIAL VALUES:\n");
    printf("\nThe following calls should "
	   "not trigger error messages:\n\n");
    for (k = 1; k <= 5; ++k)
    {
	TYPE	ExpArg1, ExpArg2;

	ExpArg1 = (TYPE)LDURand() * (TYPE)MachData.Radix;
	ExpArg2 = -ExpArg1;
	ExpAns =
	    NAME(exp)(ExpArg1) * NAME(exp)(ExpArg2) - (TYPE)1.0;

	printf("x = %.10Lf, %s(x) * %s(-x) - 1.0 = %+.25LG\n",
		(LDBL)ExpArg1, FunStr,
		FunStr, (LDBL) ExpAns);
    }
    fflush(NULL);

    ExpAns = NAME(exp)((TYPE)0) - (TYPE)1;
    printf("\n\t%s(0) - 1 = %.10LG\n", FunStr,
	    (LDBL)(ExpAns));

    ExpArg = (TYPE)1;
    for (k = 1; k <= MachData.FracDigs / 2; ++k)
	ExpArg *= (TYPE)MachData.Radix;

    ExpArg *= MachData.Min;
    ExpAns = NAME(exp)(NAME(log)(ExpArg));
    fflush(NULL);
    printf("\t%s(%s(%.20LG)) = %.20LG\n", FunStr,
	MAK_STR(NAME(log)), (LDBL)ExpArg, (LDBL)ExpAns);

    ExpArg = (TYPE)1;
    for (k = 1; k <= MachData.FracDigs / 2; ++k)
	ExpArg *= (TYPE)MachData.Radix;

    ExpArg = MachData.Max *
	((TYPE)1. - (TYPE)1. / ExpArg);
    ExpAns = NAME(exp)(NAME(log)(ExpArg));
    fflush(NULL);

    printf("\t%s(%s(%.20LG)) = %.20LG\n", FunStr,
	MAK_STR(NAME(log)), (LDBL)ExpArg, (LDBL)ExpAns);

    ExpArg = NAME(log)(MachData.Max) / (TYPE)2;
    ExpAns = NAME(exp)(ExpArg);
    fflush(NULL);

    printf("\t%s(%.20LG) =  %.20LG\n", FunStr,
	    (LDBL)ExpArg, (LDBL)ExpAns);

    ExpArg = NAME(exp)(ExpArg / (TYPE)2);
    printf("\t\t\t  should equal %.20LG\n",
	    (LDBL)(ExpArg * ExpArg));

    printf("\nBOUNDARY VALUES:\n");
    printf("\nThe following calls might "
	   "trigger error messages\n");
    fflush(NULL);

    ExpArg = -(TYPE)1 / NAME(sqrt)(MachData.Min);
    ExpAns = NAME(exp)(ExpArg);
    fflush(NULL);
    printf("\t%s(%+.10LG) = %.10LG\n", FunStr,
	    (LDBL)ExpArg, (LDBL)ExpAns);
    fflush(NULL);

    ExpArg = -ExpArg;
    ExpAns = NAME(exp)(ExpArg);
    fflush(NULL);
    printf("\t%s(%+.10LG) = %.10LG\n", FunStr,
	    (LDBL)ExpArg, (LDBL)ExpAns);
    return (0);
}
