/* ======== */
/* xvcbrt.h */
/* ======== */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN   xcbrt
#define TST_FUN   NAME(cbrt)
// --------------------------|
// TstFun(x) versus ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)xtold(x);

    pzz = EXT_FUN(FunArg);

    return NAME(cbrt)(FunArg);
}
/* ==================================================================== */
/* main - Compares standard cbrt function with extended version		*/
/* ==================================================================== */
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    const
    char	*FunStr = MAK_STR(TST_FUN);
    char	 Label[128];
    int		 RadixPow;
    TYPE	 HiLim, LoLim, TestArg, TestAns;
    MACHAR_STRU  MachData;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);
    MachData = GetMachar();

    printf("There are %d Base %d Significant Digits\n",
	MachData.FracDigs, MachData.Radix);

    RadixPow = MachData.Radix*MachData.Radix*MachData.Radix;
    HiLim = 1.0;
    LoLim = (TYPE)1.0/(TYPE)RadixPow;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 1,
	FunStr, TEST_SIZE, (LDBL)LoLim, (LDBL)HiLim);

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 1.0;
    HiLim = RadixPow;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 2,
	FunStr, TEST_SIZE, (LDBL)LoLim, (LDBL)HiLim);

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    printf("\nSPECIAL VALUES:\n");

    printf("\nThese calls should not "
	   "trigger error messages\n");
    TestArg = (TYPE)0.0;
    TestAns = NAME(cbrt)(TestArg);
    if (TestAns == TestArg)
    {
	printf("\t%s(0) = 0 (Exactly)\n", FunStr);
    }
    else
    {
	printf("\t%s(0) Failed = %LG\n",
		FunStr, (LDBL)TestAns);
    }
    TestArg = (TYPE)1.0;
    TestAns = NAME(cbrt)(TestArg);
    if (TestAns == TestArg)
    {
	printf("\t%s(1) = 1 (Exactly)\n", FunStr);
    }
    else
    {
	printf("\t%s(1) Failed = %LG\n", FunStr,
		(LDBL)TestAns);
    }
    printf("\n\tEpsNeg = %.20LG\n",
	(long double)MachData.EpsNeg);

    TestArg = (TYPE)1.0 - MachData.EpsNeg;
    TestAns = NAME(cbrt)(TestArg);
    if (TestAns == (TYPE) 1.0)
    {
	printf("\t%s(1 - EpsNeg) = 1 (Exactly)\n",
		FunStr);
    }
    else
    {
	TestArg = (TYPE) 1.0 - TestAns;
	printf("\t%s(1 - EpsNeg) = 1 - %.20LG\n",
		FunStr, (long double)TestArg);
    }
    printf("\n\tEps    = %.20LG\n",
	(long double)MachData.Eps);

    TestArg = (TYPE) 1.0 + MachData.Eps;
    TestAns = NAME(cbrt)(TestArg);
    if (TestAns == (TYPE) 1.0)
    {
	printf("\t%s(1 + Eps) = 1 (Exactly)\n",
		FunStr);
    }
    else
    {
	TestArg = TestAns - (TYPE) 1.0;
	printf("\t%s(1 + Eps) = 1 + %.20LG\n",
		FunStr, (long double)TestArg);
    }

    TestArg = MachData.Min;
    printf("\n\tMin = %.20LG\n", (LDBL)TestArg);

    TestAns = NAME(cbrt)(TestArg);
    printf("\t%s(Min) = %.20LG\n", FunStr, (LDBL)TestAns);

    TestArg = MachData.Max;
    printf("\n\tMax = %.20LG\n", (LDBL)TestArg);

    TestAns = NAME(cbrt)(TestArg);
    printf("\t%s(Max) = %.20LG\n", FunStr, (LDBL)TestAns);

    printf("\nBOUNDARY VALUE:\n");
    printf("\tFinding Cube Root of "
	   "a Negative Number:\n");
    printf("\n\tThis call must not "
	   "trigger an error message\n");

    fflush(NULL);
    TestArg = (TYPE)-1.0E6;
    TestAns = NAME(cbrt)(TestArg);

    fflush(NULL);
    printf("\tResult: %s(%.20LG) = %.20LG\n",
	FunStr, (LDBL)TestArg, (LDBL) TestAns);

    return (0);
}
