/* ======== */
/* xvatan.h */
/* ======== */
// After Cody & Waite and Plauger
#include "xverfun.h"
#include "xverfun2.h"
#define	EXT_FUN_1	xatan
#define	EXT_FUN_2	xatan2
#define	TST_FUN_1	NAME(atan)
#define	TST_FUN_2	NAME(atan2)
// -----------------------
// atan(x) versus xatan(x)
// -----------------------
static
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    AtanArg;

    AtanArg = (TYPE)xtold(x);

    pzz = EXT_FUN_1(AtanArg);

    return NAME(atan)(AtanArg);
}
// -------------------------
// atan2(x) versus xatan2(x)
// -------------------------
static
qfloat f2 (qfloat x, qfloat y, qfloat &pzz)
{
    TYPE    FunArgX, FunArgY;

    FunArgX = (TYPE)xtold(x);
    FunArgY = (TYPE)xtold(y);

    pzz = EXT_FUN_2(FunArgY, FunArgX);

    return NAME(atan2)(FunArgY, FunArgX);
}
// --------------------------------------------------------------------
// Main Program to Test atan/atan2 Functions versus Extended atan/atan2
// --------------------------------------------------------------------
static const TYPE PI = 3.141592653589793238462643383279502884L;

#define	MAK_STR(x)	STR_NAME(x)
#define	STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int		 k;
    TYPE	 RadixPow;
    TYPE	 AtanArg, AtanAns, Atn2ArgX, Atn2ArgY,
		 Atn2Ans;
    char	 Label[128];
    const char  *FunStr1 = MAK_STR(TST_FUN_1);
    const char  *FunStr2 = MAK_STR(TST_FUN_2);
    MACHAR_STRU  MachData;

    printf("Test of %s(x)   vs. xatan(x) & "
	           "%s(x,y) vs. xatan2(x,y):\n",
	    FunStr1, FunStr2);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr1,
		TEST_SIZE, -0.0625L, 0.0625L);
    XVerFun(MachData, TEST_SIZE, -0.0625L, 0.0625L,
		&f1, Label);

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr1,
		TEST_SIZE, 0.0625L, 1.00L);
    XVerFun(MachData, TEST_SIZE, 0.0625L, 1.0000L,
		&f1, Label);

    sprintf(Label, "Test 3: %s(x,y) for %d values of "
		"\n\tx in (%+.10LG, %+.10LG) and"
		"\n\ty in (%+.10LG, %+.10LG)", FunStr2,
		TEST_SIZE, -0.0625L, 0.0625L,
		 -0.0625L, 0.0625L);
    XVerFunXY(MachData, TEST_SIZE, -0.0625L, 0.0625L,
			-0.0625L, 0.0625L, &f2, Label);

    sprintf(Label, "Test 4: %s(x,y) for %d values of "
		"\n\tx in (%+.10LG, %+.10LG) and"
		"\n\ty in (%+.10LG, %+.10LG)", FunStr2,
		TEST_SIZE, 0.0625L, 1.0000L,
		-1.0000L, -0.0625L);
    XVerFunXY(MachData, TEST_SIZE, 0.0625L, 1.0000L,
			-1.0000L, -0.0625L, &f2, Label);

    printf("\nSPECIAL VALUES:\n\n");

    printf("%s(x) + %s(-x) for random values in "
	   "[0, 5)\n", FunStr1, FunStr1);

    for (k = 1; k <= 5; ++k)
    {
	AtanArg = (TYPE) LDURand() * (TYPE)5;
	AtanAns = NAME(atan) (AtanArg);
	AtanAns += NAME(atan) (-AtanArg);

	printf("\tx =%14.10Lf, %s(x) + %s(-x) = %.10LG\n",
	    (LDBL) AtanArg, FunStr1, FunStr1,
	    (LDBL) AtanAns);
    }

    RadixPow = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	RadixPow *= (TYPE) MachData.Radix;

    AtanArg = (TYPE) (LDURand() / RadixPow);

    printf("\n%s(x) - x for small x\n", FunStr1);

    for (k = 1; k <= 5; ++k)
    {
	AtanAns = NAME(atan)(AtanArg) - AtanArg;
	printf("\tx = %.10LE, %s(x) - x = %.20LG\n",
	    (LDBL) AtanArg, FunStr1,
	    (LDBL) AtanAns);

	AtanArg /= (TYPE) MachData.Radix;
    }
    printf("\nTesting atan(y/x) vs. atan2(y, x)\n");

    for (k = 0; k < 4; ++k)
    {
	static int  X[4] = {+1, -1, +1, -1};
	static int  Y[4] = {+1, +1, -1, -1};
	static int  Q[8] = {+0, -1, -1, +0,
			    +0, +1, +1, +0};
	Atn2ArgX = (TYPE) X[k];
	Atn2ArgY = (TYPE) Y[k];
	printf("\tx = %+.10Lf, y = %+.10Lf\n",
	    (LDBL) Atn2ArgX, (LDBL) Atn2ArgY);
	fflush(NULL);

	AtanAns = NAME(atan) (Atn2ArgY / Atn2ArgX);
	Atn2Ans = NAME(atan2) (Atn2ArgY, Atn2ArgX);
	fflush(NULL);
	printf("\t\t%s(y/x)  - %s(y,x)  = %+.10LG*pi"
		" (Expect %+d*pi)\n", FunStr1, FunStr2,
		(LDBL) ((AtanAns-Atn2Ans) / PI), Q[2*k]);
	fflush(NULL);

	AtanAns = NAME(atan) (-Atn2ArgY / Atn2ArgX);
	Atn2Ans = NAME(atan2) (Atn2ArgY, -Atn2ArgX);
	fflush(NULL);
	printf("\t\t%s(-y/x) - %s(y,-x) = %+.10LG*pi"
		" (Expect %+d*pi)\n", FunStr1, FunStr2,
		(LDBL) ((AtanAns-Atn2Ans) / PI), Q[2*k+1]);
	fflush(NULL);
    }

    printf("\n    Testing underflow for "
	   "very small argument\n");
    AtanArg = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	AtanArg /= (TYPE) MachData.Radix;

    AtanAns = NAME(atan)(AtanArg);

    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanArg, FunStr1,
	(LDBL) AtanAns);

    printf("\nBOUNDARY VALUES:\n");

    printf("\nThe following calls should "
	   "not trigger error messages:\n");
    fflush(NULL);

    AtanArg = MachData.Max;
    AtanAns = NAME(atan)(AtanArg);
    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanArg, FunStr1,
	(LDBL) AtanAns);
    fflush(NULL);

    AtanArg = MachData.Min;
    AtanAns = NAME(atan)(AtanArg);
    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AtanArg, FunStr1,
	(LDBL) AtanAns);
    fflush(NULL);

    Atn2ArgX = (TYPE) 1;
    Atn2ArgY = (TYPE) 0;
    Atn2Ans = NAME(atan2)(Atn2ArgY, Atn2ArgX);
    fflush(NULL);
    printf("\tx = %.10LG, y = %.10LG, "
	   "%s(y, x) = %.10LG\n",
	   (LDBL) Atn2ArgX,
	   (LDBL) Atn2ArgY, FunStr2,
	   (LDBL) Atn2Ans);
    fflush(NULL);

    Atn2ArgX = MachData.Min;
    Atn2ArgY = MachData.Max;
    Atn2Ans = NAME(atan2)(Atn2ArgY, Atn2ArgX);
    fflush(NULL);
    printf("\tx = %.10LG, y = %.10LG\n"
	   "\t\t%s(y, x) = %.20LG\n",
	   (LDBL) Atn2ArgX,
	   (LDBL) Atn2ArgY, FunStr2,
	   (LDBL) Atn2Ans);
    fflush(NULL);

    Atn2ArgX = MachData.Max;
    Atn2ArgY = MachData.Min;
    Atn2Ans = NAME(atan2)(Atn2ArgY, Atn2ArgX);
    fflush(NULL);
    printf("\tx = %.10LG, y = %.10LG\n"
	   "\t\t%s(y, x) = %.20LG\n",
	   (LDBL) Atn2ArgX,
	   (LDBL) Atn2ArgY, FunStr2,
	   (LDBL) Atn2Ans);

    printf("\nThe following call might "
	   "trigger an error message:\n");
    fflush(NULL);

    Atn2ArgX = (TYPE) 0;
    Atn2ArgY = (TYPE) 0;
    Atn2Ans = NAME(atan2)(Atn2ArgY, Atn2ArgX);
    fflush(NULL);
    printf("\tx = %.10LG, y = %.10LG, "
	   "%s(y, x) = %.10LG\n",
	   (LDBL) Atn2ArgX,
	   (LDBL) Atn2ArgY, FunStr2,
	   (LDBL) Atn2Ans);

    return (0);
}
