/* ========= */
/* xvacosh.h */
/* ========= */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN 	xacosh
#define TST_FUN 	NAME(acosh)
// --------------------------|
// TstFun(x) versus ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)(xtold(x));

    pzz = xacosh(FunArg);

    return NAME(acosh)(FunArg);
}
// ---------------------------------------------------------
// Main Program to Test acosh Function versus Extended acosh
// ---------------------------------------------------------
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    int 	    k;
    TYPE	    RadixPow;
    TYPE	    AcoshAns, AcoshArg;
    char	    Label[128];
    const char	   *FunStr = MAK_STR(NAME(acosh));
    MACHAR_STRU     MachData;
    qfloat	    HiLim, LoLim;

    printf("Test of %s(x) vs. %s(x):\n", FunStr, EXT_FUN_STR);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = 1;
    HiLim = 1.5;

    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 1.5;
    HiLim = 2.0;

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 2.0;
    HiLim = 5.0;

    sprintf(Label, "Test 3: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    RadixPow = (TYPE) 1;
    for (k = 1; k <= (MachData.FracDigs-1)/2; ++k)
    {
	RadixPow *= MachData.Radix;
    }

    LoLim = 5;
    HiLim = 100;

    sprintf(Label, "Test 4: %s(x) for %d values in "
		   "(%+.10LG, %+.10LG)", FunStr,
		   TEST_SIZE, xtold(LoLim), xtold(HiLim));

    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    RadixPow = (TYPE) 1;
    for (k = 1; k <= (MachData.FracDigs+1)/2; ++k)
    {
	RadixPow *= MachData.Radix;
    }

    LoLim = RadixPow;
    HiLim = 4 * LoLim;

    sprintf(Label, "Test 5: %s(x) for %d values in "
		   "(%d^%d, %d^%d)", FunStr,
		   TEST_SIZE, MachData.Radix, (MachData.FracDigs+1)/2,
		   MachData.Radix, 4*((MachData.FracDigs+1)/2));
//		   TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    printf("SPECIAL VALUES:\n");
    printf("\nThe following call should "
	   "not trigger an error message:\n");

    AcoshArg = (TYPE) 1;
    AcoshAns = NAME(acosh)(AcoshArg);
    printf("\tx = %+.10LG, %s(x) = %+.10LG  (Expect +0)\n",
	    (LDBL) AcoshArg, FunStr, (LDBL) AcoshAns);

    printf("\nBOUNDARY VALUES:\n");

    printf("\tTesting %s(x) for x = maximum "
	   "floating point value\n", FunStr);
    AcoshArg = MachData.Max;
    AcoshAns = NAME(acosh)(AcoshArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AcoshArg, FunStr, (LDBL) AcoshAns);

    printf("\nThe following calls might "
	   "trigger error messages:\n");

    printf("\tTesting %s(x) for x = minimum "
	   "floating point value\n", FunStr);

    AcoshArg = MachData.Min;
    AcoshAns = NAME(acosh)(AcoshArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AcoshArg, FunStr, (LDBL) AcoshAns);

    printf("\tTesting %s(x) for x = 0\n", FunStr);

    AcoshArg = 0;
    AcoshAns = NAME(acosh)(AcoshArg);
    printf("\t\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) AcoshArg, FunStr, (LDBL) AcoshAns);

    return (0);
}
