#include <stdio.h>
#include <stdlib.h>
#include <math.h>
// Verifies Minimum = 2^-16382       = 3.36210314311209350626E-4932
//          Maximum = 2^+16384 - eps = 1.18973149535723176502E+4932
void
main()
{
    long    k;
    long double	F1 = powl(2, -16380), FSum = 0;

    for (k = 16381; k <= 16382; ++k)
    {
	F1 /= 2.0;
	if (k > 16300)
	printf("%5ld: F1 = %.20LE\n", k, F1);
    fflush(NULL);
    }

    fflush(NULL);
    printf("%4d: F1 - F1/2           = %.11LE\n", k, F1/2);
    printf("%4d: F1 - F1/2 - F1/2 -  = %.11LE\n", k+1, F1 - F1/2 - F1/2);

    F1 = powl(2, 16320);
    FSum = powl(2, 16320);
    for (k = 16321; k <= 16384; ++k)
    {
	if (k > 16380)
	{
	    printf("%4ld: ", k);
	    fflush(NULL);
	}

	F1 *= 2.0;

	if (k > 16380)
	{
	    printf("F1 = %.20LE, ", F1);
	    fflush(NULL);
	}

	FSum += F1;

	if (k > 16380)
	{
	    printf("F1 = %.20LE\n", FSum);
	    fflush(NULL);
	}
    }
    //fflush(NULL);
    //printf("%4ld: F1*2 = %.11E\n", k, F1*2);
    //printf("%4ld: F1*4 = %.11E\n", k, F1*4);
}
