listing 1 - BigNum header file
// (c) 1996 tony breitzman
// BigNum.h - a class for operating on arbitrarily large integers

# include <fstream.h>
# include <stdlib.h>
# include <string.h>
const int BASE = 10000;

class BigNum{
 protected:
  int *x;               //this array holds the BigNum
  char positive;        //sign flag
  long exp;             //array index of most significant digit

 public:
  BigNum(char *s);                        //construct from string
  BigNum(long k=0,long new_sz=0);         //construct from long
  BigNum(const BigNum &b,long new_sz=0);  //copy constructor
  ~BigNum(){delete[] x;}                  //destructor

  friend ostream& operator<<(ostream & os,
                             BigNum &b);   //for printing

  BigNum & operator=(const BigNum &b);  //assignment
  BigNum & operator=(long k);           //assignment from long
  BigNum operator+(const BigNum & b);   //addition

  BigNum operator-(const BigNum &b);    //subtraction
  BigNum operator/(const BigNum &den);  //divide bignums
  BigNum operator/(long denom);         //divide bignum by long
  BigNum operator*(const BigNum & b);   //bignum multiplication
  BigNum operator^(const long n);       //exponentiation


  //easy routines; these are easily implemented and are not
  //included here to save space. The complete listings may be
  //obtained from my web page.
  BigNum operator-();                   //unary minus
  BigNum operator+(const long k);       //addition with long
  BigNum operator-(const long k);       //Bignum - long
  BigNum operator*(long k);             //multiply bignum * long
  BigNum operator%(const BigNum &denom);//remainder of division
  long operator%(const long denom);     //rem. Of bignum / long
  char operator<=(const BigNum &b);
  char operator>(const BigNum &b);
  char operator>=(const BigNum &b);
  char operator==(const BigNum &b);
  char operator<(const BigNum &b);
  char operator<=(const long k);
  char operator>(const long k);
  char operator>=(const long k);
  char operator==(const long k);
  char operator<(const long k);
  char is_zero();               //returns 1 if
                                //value of BigNum is zero
  void asl(const long n);       //arithmetic shift left;
                                //equivalent to multiplying by
                                //base n times
  void asr(const long n);       //arithmetic shift right
  long BigNum2Long();           //convert a bignum to a long
                                //if possible
  BigNum abs(const BigNum &b);  //absolute value
  void random(const int size);  //makes a random bignum of size
                                //digits
};
