int main()
{
    int n = 5;
    vector<double> offDiag(n-1, -1.0), diag(n, 2.0);
    tridiagonalMatrix<double> T(n);

    T.mainDiagonal() = diag;
    T.subDiagonal() = T.superDiagonal() = offDiag;

    vector<double> b(n, 5.0);

    cout << "Solving ..." << endl;
    vector<double> x = T.solve(b);

    for (int i=0; i<n; i++)
        cout << x[i] << endl;

    cout << endl << "Checking ..." << endl;
    vector<double> z = T*x;

    for (i=0; i<n; i++)
        cout << z[i] << endl;

    return 0;
}

solving ...
12.5
20
22.5
20
12.5

Checking ...
5
5
5
5
5

