typedef unsigned long	Time;
typedef long		Address;
typedef int		Bool;
typedef double		Signal;
class MasterRun;
class Regulator;
class Configure;

extern Time mtime();
extern msleep(Time);
extern void writeDigital(Address, Bool);
extern Bool readDigital(Address);
extern void writeAnalog(Address, Signal);
extern Signal readAnalog(Address);
extern Signal abs(Signal);
extern Bool sign(Signal);
extern Signal NaN();

static Time lastDigOutTest[10];

struct Global
{
    static const Bool digitalError, true, false;
    static const Time ticksPerSecond, resetHoldoff, wdPulseInterval,
	auditInterval, watchInterval, doTestInterval;
    static const Signal analogError, voltWin, under, over;
};

const Bool   Global::digitalError    = -1;
const Bool   Global::true	     = 1;
const Bool   Global::false	     = 0;
const Time   Global::ticksPerSecond  = 1000;
const Time   Global::resetHoldoff    = 5 * Global::ticksPerSecond;
const Time   Global::auditInterval   = Global::ticksPerSecond /20.;
const Time   Global::watchInterval   = Global::ticksPerSecond /10.;
const Time   Global::wdPulseInterval = Global::ticksPerSecond /200.;
const Time   Global::doTestInterval  = 15 * Global::ticksPerSecond;
const Signal Global::analogError     = NaN();
const Signal Global::voltWin         = 0.5;
const Signal Global::over            = 1.05;
const Signal Global::under           = 0.95;
