//******************************************************************************
//
//  Name:  PID_cntl.h
//
//  Description:  Class definition for a PID (Proportional, Integral,
//                Differential) control class.  This is a reusable class
//                intended to be inherited by other objects which need PID
//                control
//
//******************************************************************************
#ifndef _PID_CNTL_H_
#define _PID_CNTL_H_

class PidControl {
	private:
		double 		KProportional,
						KIntegral,
						KDifferential,
						IntegralLimit,
						ProportionalGain,
						IntegralGain,
						DifferentialGain,
						Setpoint,
						Gain;
		unsigned		DifferentialCycle;
		unsigned		DifferentialCycleCount;
		double		ErrorSum,
						LastError;
	protected:
		PidControl( double kP, double kI, double kD, double lI, double cD );
	public:
		double CalculateGain( double position );
		virtual void   SetSetpoint( double setpoint );
		double GetProportionalGain() { return ProportionalGain; }
		double GetIntegralGain() { return IntegralGain; }
		double GetDifferentialGain() { return DifferentialGain; }
		void SetProportionalConstant( double kP )
			{ KProportional = kP; };
		void SetIntegralConstant( double kI )
			{ KIntegral = kI; }
		void SetDifferentialConstant( double kD )
			{ KDifferential = kD; }
		void SetDifferentialCycle( unsigned Dc )
			{ DifferentialCycle = Dc; }
		double GetProportionalConstant() { return KProportional; }
		double GetIntegralConstant() { return KIntegral; }
		double GetDifferentialConstant() { return KDifferential; }
		double GetIntegralLimit() { return IntegralLimit; }
      double GetSetpoint() { return Setpoint; }
	};


#endif