//******************************************************************************
//
//  Name:  pid_cntl.cpp
//
//  Description:  Implementation of the PID class
//
//******************************************************************************
#include "pid_cntl.h"
#include <math.h>

//------------------------------------------------------------------------------
//
//  Name:  PidControl::PidControl()
//
//  Description:  Class Contructor.  Initializes variables and constants from
//                arguments.
//
//------------------------------------------------------------------------------
PidControl::PidControl( double kP, double kI, double kD, double lI, double cD )
{
	KProportional = kP;
	KIntegral = kI;
	KDifferential = kD;
	IntegralLimit = lI;
	DifferentialCycle = cD;
	DifferentialCycleCount = 0;
	ProportionalGain = IntegralGain = DifferentialGain = 0;
	LastError = ErrorSum = 0;
	Gain = Setpoint = 0;
}

//------------------------------------------------------------------------------
//
//  Name:  PidControl::CalculateGain()
//
//  Description:  Calculates the P, I, and D gains and returns their sum.  The
//                separate gain values are kept to aid in tuning.
//
//------------------------------------------------------------------------------
double PidControl::CalculateGain( double position )
{
	double error = Setpoint - position;
	ErrorSum += error;
	ProportionalGain = KProportional * error;
	IntegralGain = KIntegral * ErrorSum;
	if( fabs( IntegralGain ) > IntegralLimit ) {
      if( IntegralGain > 0 )
   		IntegralGain = IntegralLimit;
      else
         IntegralGain = -IntegralLimit;
      ErrorSum -= error;
      }
	if( ++DifferentialCycleCount >= DifferentialCycle ) {
   	DifferentialGain =  KDifferential * ( error - LastError );
      DifferentialCycleCount = 0;
      }
	LastError = error;
	Gain = ProportionalGain + IntegralGain + DifferentialGain;
	return Gain;
}
void   PidControl::SetSetpoint( double setpoint )
{
	ErrorSum = 0;
	Setpoint = setpoint;
}

