// ****************************************************************************
//
// Module:  tappl.h
// Author:  Dick Lam
//
// Purpose: C++ template class header file for cgiTApplication
//
// Notes:  This is a base template class. It provides the main program for
//         a web server CGI application. The template argument is a class
//         provided by the user to process the input CGI data and deliver
//         an output page. The argument class is derived from the cgiProcessor
//         class provided by cgiFramework.
//
// ****************************************************************************

#ifndef MODULE_cgiTApplicationh
#define MODULE_cgiTApplicationh

#include <stdlib.h>
#include <iostream.h>
#include <strstrea.h>
#include <cgi/parser.h>
#include <cgi/process.h>
#include <cgi/environ.h>
#include <cgi/xcpt.h>

// class declaration
template <class T>
class cgiTApplication {

public:

   // constructor and destructor
   cgiTApplication();
   virtual ~cgiTApplication();

   // method to run the application
   virtual void run();

protected:

   strstream datastream;         // stream that contains the input data
   cgiParser myParser;           // reads and parses input data
   cgiProcessor *myProcessor;    // instance of the user-supplied class

   // put the data into the datastream
   void fillstream();

private:

   // private copy constructor and operator= (define these and make them
   // public to enable copy and assignment of the class)
   cgiTApplication(const cgiTApplication<T>&);
   cgiTApplication<T>& operator=(const cgiTApplication<T>&);

};

// ****************************************************************************

// cgiTApplication - constructor

template <class T>
cgiTApplication<T>::cgiTApplication()
   : myParser(datastream)

{
   // init instance variables
   myProcessor = 0;

   try {
      // create an instance of the template class
      myProcessor = new T;
      if (!myProcessor) throw cgiException();

      // get the data
      fillstream();
   }

   catch (cgiException) {
      // call the default processor and exit
      cgiProcessor::defprocess();
      abort();
   }
}

// ----------------------------------------------------------------------------

// ~cgiTApplication - destructor

template <class T>
cgiTApplication<T>::~cgiTApplication()

{
   delete myProcessor;
}

// ----------------------------------------------------------------------------

// run - reads and parses the data, and then runs the user-supplied processor

template <class T>
void cgiTApplication<T>::run()

{
   try {
      // read and parse the input data
      if ( myParser.parse() )
         throw cgiException();

      // run the user's processor
      if ( myProcessor->process( myParser.getList() ) )
         throw cgiException();
   }

   catch (cgiException) {
      // call the default processor and exit
      cgiProcessor::defprocess();
      abort();
   }
}

// ----------------------------------------------------------------------------

// fillstream - puts the input data into the datastream for parsing

template <class T>
void cgiTApplication<T>::fillstream()

{
   // determine the data source
   cgiEnvironment env;

   switch ( env.source() ) {
      case cgiget:
         // copy the data into the datastream
         datastream << env.getFormInput().c_str() << ends;
         break;

      case cgipost:
         // read the data from stdin, using the data length set in
         // the environment
         {
            char c;

            for (int i = 0; i < env.getDataLength(); i++) {
               cin.get(c);
               datastream.put(c);
            }
            datastream << ends;
         }
         break;

      default:
         throw cgiException();
   }
}

#endif

// ****************************************************************************

// end of tappl.h
