[Caption: HTML source output from the program in Listing 5]

// myproc.C - source file for myProcessor
#include <cgi/htmlhelp.h>
#include "myproc.h"

int myProcessor::process(cgiDataList& data)
{
   // write the document type and HTML header
   cgiHTMLHelper html(cout);
   html.contentType();
   html.header("Payment method");

   // print out the user's name (note the associative
   // array syntax), and start a new form after the
   // horizontal rule line (htmlrule)
   cout << htmlpara
        << "Name: " << data["firstname"]
        << " " << data["lastname"] << endl
        << htmlrule
        << htmlformpost("http://k12web/scripts/parse.exe")
        << endl
        << htmlpara
        << "Select a payment method to use for " << endl
        << "your order. Then press the " << endl
        << htmlitalics << "Next" << htmlenditalics
        << " button."
        << htmlbreak << endl;

   // display a listbox of six choices for payment
   html.listbox("payment", 6);
   html.listoption("Mastercard", true);
   html.listoption("Visa");
   html.listoption("Discover");
   html.listoption("American Express");
   html.listoption("Optima");
   html.listoption("Other (specify below)");
   html.endlistbox();

   // optional entryfield for a payment type not
   // listed above
   cout << htmlpara
        << "Specify other credit card type here: ";
   html.entryfield("othercard");

   // entryfield for the user's card number
   cout << htmlpara
        << "Card number:";
   html.entryfield("cardnum");

   // entryfield for the user's card expiration date
   cout << htmlpara
        << "Expiration date:";
   html.entryfield("expdate", "MM/YY", 5);

   // the submit button to go to the next form
   cout << htmlpara;
   html.submitbutton("Next >>");

   // write the first and last names as hidden fields
   // so the next form will receive them (hidden fields
   // are not shown, but the next form will still get
   // them as a name-value pair)	
   html.hidden( "firstname", data["firstname"].c_str() );
   html.hidden( "lastname", data["lastname"].c_str() );

   // write the trailer and exit
   cout << htmladdress("Last modified Dec 29, 1995 / "
                       "<I>rblam@watson.ibm.com</I>")
        << endl;
   html.trailer();

   return 0;
}



