// These brushes are global and shared by a few objects.
wxBrush *brushes[10];

wxFrame *TrisApp::OnInit(void) {
  // Seed random number generator based on current time.
  time_t tm;
  tm = time(NULL);
  srand(tm);

  // Create the base frame for the application.
  appFrame = new TrisFrame(NULL);

  // Create the menu.
  wxMenu *fileMenu = new wxMenu;
  fileMenu->Append(WXTRIS_MENU_START, "&Start", "Start a new game");
  fileMenu->Append(WXTRIS_MENU_HIGHSCORES, "&High Scores",
                   "Show high scores");
  fileMenu->Append(WXTRIS_MENU_QUIT, "E&xit", "Quit wxTris");
  appFrame->menuBar = new wxMenuBar;
  appFrame->menuBar->Append(fileMenu, "&File");
  appFrame->SetMenuBar(appFrame->menuBar);

  // Set up colors. These will be used for the duration of the game.
  wxColor c1("BLACK");
  wxColor c2("RED");
  ...
  wxColor c9("GREY");

  // trisBLACK .. trisGREY are enumerated starting from 0.
  brushes[trisBLACK] = new wxBrush(c1, wxSOLID);
  brushes[trisRED] = new wxBrush(c2, wxSOLID);
  ...
  brushes[trisGREY] = new wxBrush(c9, wxSOLID);

  // Create the playing field.
  field = new TrisField(appFrame);

  gameState = NO_GAME;

  appFrame->Show(TRUE);
  return appFrame;
}
