// Example of Printing - traditional GDI approach
#include <stdio.h>
#include <windows.h>
#include <assert.h>

//Max 20 printers may be defined
#define MAX_PRINTERS 20
#define MAX_PRINTER_NAME 100

//Array to store printer names
char PrinterNames[MAX_PRINTERS][MAX_PRINTER_NAME];
int NumPrinters=0;


void FindPrinters(void)
{
// Cycle though the list of available printers.
// Store the printer names in PrinterNames[][].

BYTE *pbuf;
DWORD dwSize, dwPrinters;

// Find out how much bytes is needed to
// hold PRINTER_INFO_5 array
EnumPrinters(PRINTER_ENUM_LOCAL,NULL,
	5, NULL,0,&dwSize, &dwPrinters);

pbuf = new BYTE[dwSize];

//Read in the printer array
EnumPrinters(PRINTER_ENUM_LOCAL,
NULL,5,pbuf,dwSize,
	&dwSize, &dwPrinters);

printf("Available Printers:\n");
if (dwPrinters != 0) {
	PRINTER_INFO_5 * pPrnInfo =
   	(PRINTER_INFO_5 *) pbuf;
   for (NumPrinters=0; NumPrinters < dwPrinters;
   	NumPrinters++,pPrnInfo++) {
      strcpy(&(PrinterNames[NumPrinters][0]),
      		 pPrnInfo->pPrinterName);
      printf("%d. %s\n",NumPrinters,
             pPrnInfo->pPrinterName);
      } // For
	} // if
delete[] pbuf;
}


void main(void)
{
int Pindex;
HANDLE hDC;
DOCINFO di;
TEXTMETRIC tm;
int FontYSize;

FindPrinters();

printf("Select a printer from 0 through %d:",
   NumPrinters-1);
scanf( "%d",&Pindex);

//  Get Device Context for printer
hDC = CreateDC(NULL,PrinterNames[Pindex],
               NULL,NULL);
assert(hDC != NULL);

// Set up DOCINFO print parameters
ZeroMemory(&di,sizeof(DOCINFO));
di.cbSize = sizeof(DOCINFO);
di.lpszDocName= "- Dave's Example 3 Printout -";

// Calculate Vertical size of Font
if (GetTextMetrics(hDC,&tm) == FALSE)
	assert(0);
FontYSize = tm.tmHeight + tm.tmExternalLeading;

if (StartDoc(hDC,&di) <= 0)
	assert(0);

if (StartPage(hDC) <= 0)
	assert(0);

//Print three lines
TextOut(hDC,0,0,"Hello,Line 1",12);
TextOut(hDC,0,FontYSize * 1,"Hello,Line 2",12);
TextOut(hDC,0,FontYSize * 2,"Hello,Line 3",12);

EndPage(hDC);
EndDoc(hDC);
DeleteDC(hDC);
}
