/*****************************************************************************/
/*                                                                           */
/*                 (C) Copyright 1991-1996  Alberto Pasquale                 */
/*                                                                           */
/*                   A L L   R I G H T S   R E S E R V E D                   */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   How to contact the author:  Alberto Pasquale of 2:332/504@fidonet       */
/*                               alberto.pasquale@mo.nettuno.it              */
/*                               Viale Verdi 106                             */
/*                               41100 Modena                                */
/*                               Italy                                       */
/*                                                                           */
/*****************************************************************************/

// Feature.Cpp

// This is a sample source for a NEF Feature DLL.
// It only writes to the screen the full filename, tag and desc of
// tossed files.
// A prefix can be specified with the "OutPrefix" cfg statement; example:
// OutPrefix "New File: "


#include <string.h>
#include <stdio.h>
#include "NeFeat.H"


static FeatOut pf;        // function for output to screen and log
static char outpref[100];


APIRET APIENTRY _export Init (FeatOut prnf)
{
    pf = prnf;
                        // default output prefix
    strcpy (outpref, "New File: ");
    return NFI_OK;
}


APIRET APIENTRY _export ParseCfg (PCSZ clnline)
{
   char *p;
   int len;

    if (strnicmp (clnline, "OutPrefix ", 10) == 0) {
        p = clnline;
        p += 10;                // skip the keyword
        p += strspn (p, " ");   // skip space
        if (*p != '\"')
            return NFP_ERR;
        p ++;                   // skip opening quotes
        len = strlen (p);
        if (len == 0)
            return NFP_ERR;
        if (*(p+len-1) != '"')   // check closing quotes
            return NFP_ERR;
        len --;
        strncpy (outpref, p, len);    // store format string in static data
        outpref[len] = '\0';
        return NFP_OK;
    }
    return NFP_ERR;
}


APIRET APIENTRY _export BeforeNefToss (PCSZ fullname, PCSZ Tag, PCSZ Desc)
{
    pf (FO_BOTH, '*', "%s%s %s\n", outpref, fullname, Tag);
    return BNT_OK;
}


APIRET APIENTRY _export AfterNefToss (_TICDATA *td)
{
    pf (FO_BOTH, ' ', "%s\n", td->desc);
    return ANT_OK;
}
