/****************************************************************************/
/*        rxExecut OS/2-Rexx    Shell for Larc & rList                      */
/****************************************************************************/
                                   /*  Ctrl-<1..9> (NUM-Block) directories  */
Ctrl_numDir.1 = 'D:\TOOLD'
Ctrl_numDir.2 = 'E:\TOOLE'
Ctrl_numDir.3 = 'F:\TOOLF'
Ctrl_numDir.4 = 'E:\TRY'
Ctrl_numDir.5 = 'F:\GTOOL'
Ctrl_numDir.6 = 'F:\OS2'
Ctrl_numDir.7 = 'F:\INF'
Ctrl_numDir.8 = 'F:\FILES'
Ctrl_numDir.9 = 'F:\FSEND\LARC24'
                                   /*  Alt-<0..9> (not NUM-Block) Macros    */
alt_1         = 'start /PM '
alt_2         = 'Example_2 '
alt_3         = 'Example_3 '
alt_4         = 'Example_4 '
alt_5         = 'Example_5 '
alt_6         = 'Example_6 '
alt_7         = '| start /F /C rlist '
alt_8         = 'tedit f:\toolf\rxExec.cmd '
alt_9         = 'tedit f:\toolf\rxLarc.cmd '
alt_0         = 'grep -Cil -e "   "  *.cmd '
                                   /*  MAX_History: older cmds are deleted  */
MAX_History   = 10
Echo_off_BOOL = 0                  /*  1 turns off ECHO of commands         */
/****************************************************************************/
parse arg outTxt, firstReturnBOOL, directExeBOOL, A_execOpt, cmdShortBOOL, command, pathCurfileN, currD.0, currD.1, side, C_numDir_0.0, C_numDir_0.1, selectedFilesSTR.0, selectedFilesSTR.1, archivFile.0, archivFile.1, timeit, noHistoryBOOL
   call KBinitSUBR
   select                    /*   change directory  &  return Ctrl-0<DIR>   */
      when command = KB.C_0 then  RETURN GonumDirSUBR( 0, outTxt)
      when command = KB.C_1 then  RETURN GonumDirSUBR( 1, outTxt)
      when command = KB.C_2 then  RETURN GonumDirSUBR( 2, outTxt)
      when command = KB.C_3 then  RETURN GonumDirSUBR( 3, outTxt)
      when command = KB.C_4 then  RETURN GonumDirSUBR( 4, outTxt)
      when command = KB.C_5 then  RETURN GonumDirSUBR( 5, outTxt)
      when command = KB.C_6 then  RETURN GonumDirSUBR( 6, outTxt)
      when command = KB.C_7 then  RETURN GonumDirSUBR( 7, outTxt)
      when command = KB.C_8 then  RETURN GonumDirSUBR( 8, outTxt)
      when command = KB.C_9 then  RETURN GonumDirSUBR( 9, outTxt)
      otherwise do
         call rxinitSUBR
         call pulloldcmdSUBR
      end
   end
   select
      when command=KB.A_F8    then command =HistoryMenuSUBR()
      when command=KB.C_X     then actcmd  =X_HistorySUBR()
      when command=KB.A_insK  then command =a_insertySUBR()
      when command=KB.C_retnK then command =filespec('N', pathCurfileN)
      when command=KB.C_T     then command =parseFileStringSUBR( selectedFilesSTR.side,1)
      when command=KB.C_F     then command =pathCurfileN
      otherwise NOP
   end
   if \firstReturnBOOL then call outTxtSUBR
   do until firstReturnBOOL
      if \directExeBOOL then command=rxanswerCmdSUBR( RC timeDisplay '['directory()'>',' '||command)
      else directExeBOOL=0
      command = strip( command)
      select
         when command=KB.F10 then do ; firstReturnBOOL=1 ; outTxt=command ; end
         when command=''|command=KB.F9|command=KB.C_O|command=KB.S_F3 then firstReturnBOOL=1
         otherwise do
            call outTxtSUBR
            if cmdShortBOOL & pos('!',command)>0 then call prevCommandLineSUBR command
            else call CommandLineSUBR command
            call new_cmdQueHistSUBR
            command='' ;new_cmd='' ;outTxt=SysTextScreenRead( 0,0,zeile*spalte)
         end
      end
   end
return outTxt

HistoryMenuSUBR:
   call HistproveDoublSUBR
   do queued() ; pull some ; end
   do z=1 to oldcommand.0 ; queue oldcommand.z ; end
   ret = rlist(,'S',1,0, ' ? ESC/Return to execute a line of an old command?' )
   parse var ret anz old
   if anz>0 then command = oldcommand.old
   else command=''
return command

pulloldcmdSUBR:
   if noHistoryBOOL then RETURN 0
   old_Q = rxqueue('set', oldCmdQueue)
   z =0
   if rxqueue('GET')<>oldCmdQueue then noHistoryBOOL=1
   else do
      noHistoryBOOL=0
      q = queued()
      anf = q- MAX_History
      do i=1 to q
         parse pull some
         if i>anf then do
            z=z+1
            oldcommand.z = some
            queue some
         end
      end
      old_Q = rxqueue('set', old_Q)
   end
   oldcommand.0      = z
   firstqN           = z
   actcmd            = z+1
   oldcommand.actcmd = ''
return 0

X_HistorySUBR:
   parse arg MessageDisplaySTRING
   call HistproveDoublSUBR
   do queued() ; pull some ; end
   do z=1 to oldcommand.0 ; queue ' ? ' oldcommand.z ; end
   ret = rlist(,'M',1,0,delHistMessageSTRING MessageDisplaySTRING )
   parse var ret anzN all
   do z=1 to anzN
      next = word( all, z)
      oldcommand.next = ''
   end
   q = 0
   do z=1 to oldcommand.0
      if oldcommand.z <> '' then do
         q = q+1
         if q<z then oldcommand.q = oldcommand.z
      end
   end
   oldcommand.0      = q
   actcmd            = q+1
   oldcommand.actcmd = ''
   command=''
   new_cmd=''
   call outTxtSUBR
   if noHistoryBOOL=1 then NOP
   else do
      old_Q = rxqueue('set', oldCmdQueue)
      do queued() ; pull some ; end
      do q=1 to oldcommand.0 ; queue oldcommand.q ; end
      call rxqueue 'set', old_Q
   end
return actcmd

HistproveDoublSUBR:
   if noHistoryBOOL=1 then RETURN 0
   old_Q = rxqueue('set', oldCmdQueue)
   oldcommand.0 =queued()
   do z=1 to oldcommand.0 ; parse pull oldcommand.z ; end
   z=0
   do q=1 to oldcommand.0
      sameBOOL=0
      do r=q+1 to oldcommand.0
         if oldcommand.q=oldcommand.r then leave r
      end
      if r>oldcommand.0 then do
         z=z+1 ; if z<q then oldcommand.z=oldcommand.q
      end
   end
   oldcommand.0 = z
   do z=1 to oldcommand.0 ; queue oldcommand.z ; end
   call rxqueue 'set', old_Q
return 0

new_cmdQueHistSUBR:
   if new_cmd='' then NOP
   else do
      h = oldcommand.0
      if oldcommand.h=new_cmd then NOP
      else do
         h = h+1
         oldcommand.0 = h
         oldcommand.h = new_cmd
         if noHistoryBOOL<>1 then do
            old_Q = rxqueue('set', oldCmdQueue)
               queue oldcommand.h
            call rxqueue 'set', old_Q
         end
      end
   end
   actcmd =oldcommand.0+1
return 0

CommandLineSUBR:
   parse arg command
   old_Dir = directory()
   if command='' then RETURN 0
   ss = translate( command, ' ', '("|@)&')
   ss = strip( ss)
   ss = translate( ss)
   if new_cmd='' then new_cmd = command
   if pos('&',command)>0 then do
      if words(ss)>0 then ss = word( ss,1)
      if timeresetBOOL then call time 'R'
      if 'CALL'=ss | 'START'=ss | 'DETACH'=ss
         then address 'CMD' command
      else    address 'CMD' 'cmd /c "'command'"'
   end
   else if pos(':', reverse(ss))=1 & length(ss)=2 then do
      call directory ss
   end
   else if pos('CD .',ss)=1|pos('CD..',ss)=1|pos('CD\ ',ss||' ')|pos('CD \ ',ss||' ')=1 then do
      call directory strip(substr(ss,3))
   end
   else if pos('CD ', ss)=1 then do
      ss = strip( substr( ss,3))
      new_DIR  = directory( ss)
      if new_DIR<>'' then fund.1 =new_DIR
      else do
         fund.1 = ss
         call SysFileTree ss||'*', 'fund.', 'DO'
         if fund.0>0 then do
            if fund.0>1 then say
            do d=2 to fund.0 ; say right(' else: ',14) fund.d ; end
            fund.1 = directory( fund.1)
         end
      end
      new_cmd = 'cd' fund.1
   end
   else do
      if words(ss)>0 then ss = word( ss,1)
      if 'CALL'=ss | 'START'=ss | 'DETACH'=ss then do
         if timeresetBOOL then call time 'R'
         address 'CMD' command
      end
      else if ss='FOR' | ss='IF' then do
         if timeresetBOOL then call time 'R'
         address 'CMD' 'cmd /c "'command'"'
      end
      else do
         ssp = ''
         if pos('\', ss)>0 then do
            if pos('.', ss)>0 then ssp = stream( ss, 'C', 'query exists')
            if ssp ='' then ssp =stream( ss||'.cmd', 'C', 'query exists')
            if ssp ='' then ssp =stream( ss||'.exe', 'C', 'query exists')
         end
         else do
            if pos('.', ss)>0 then ssp =SysSearchPath('PATH', ss )
            if ssp ='' then ssp =SysSearchPath('PATH', ss||'.cmd')
            if ssp ='' then ssp =SysSearchPath('PATH', ss||'.exe')
         end
         if ssp <> '' then do
            if pos('.CMD', translate( right(ssp,4)))=1 then ssp = 'call' ssp
            posy_ss = pos( ss, translate(command))
            command = left( command,posy_ss-1)||ssp||substr(command, posy_ss+length(ss))
         end
         if timeresetBOOL then call time 'R'
         address 'CMD' command
      end
   end
   if directory()<>old_Dir then c_numDir_0.side = old_Dir
   timeDisplay = left( time(timeit),11)
return 0

prevCommandLineSUBR:
   parse arg nach
   old_side = side
   side = first_side
   opposide = 1-side
   Pnew_cmd = nach
   menu. =0
   input =0
   tempfile.0 =0
   taggedBOOL=0
   alltaggedside =0
   menu.Nr.p =''
   insPos = pos('!', nach)
   do while nach<>''
      if insPos>1 then do
         if taggedBOOL then call taggedAllSUBR left(nach,insPos-1)
         else menu.Nr.p = menu.Nr.p||left(nach,insPos-1)
      end
      if insPos>0 then chary = substr(nach,insPos,2)
      else chary =''
      select
         when chary='!f' then do
             if taggedBOOL then call taggedAllSUBR pathCurfileN
             else menu.Nr.p = menu.Nr.p||pathCurfileN
             nach = substr(nach, insPos+2)
         end
         when chary=='!p' then do
             if taggedBOOL then call taggedAllSUBR strip(currD.side,'T','\')
             else menu.Nr.p = menu.Nr.p||strip(currD.side,'T','\')
             nach = substr(nach, insPos+2)
         end
         when chary=='!P' then do
             if taggedBOOL then call taggedAllSUBR strip(currD.opposide,'T','\')
             else menu.Nr.p = menu.Nr.p||strip(currD.opposide,'T','\')
             nach = substr(nach, insPos+2)
         end
         when chary=='!s' then do
             if taggedBOOL then call taggedAllSUBR currD.side
             else menu.Nr.p = menu.Nr.p||currD.side
             nach = substr(nach, insPos+2)
         end
         when chary=='!S' then do
             if taggedBOOL then call taggedAllSUBR currD.opposide
             else menu.Nr.p = menu.Nr.p||currD.opposide
             nach = substr(nach, insPos+2)
         end
         when chary=='!z' then do
             if taggedBOOL then call taggedAllSUBR archivFile.side
             else menu.Nr.p = menu.Nr.p||archivFile.side
             nach = substr(nach, insPos+2)
         end
         when chary=='!Z' then do
             if taggedBOOL then call taggedAllSUBR archivFile.opposide
             else menu.Nr.p = menu.Nr.p||archivFile.opposide
             nach = substr(nach, insPos+2)
         end
         when chary=='!n' then do
             nach = substr(nach, insPos+2)
         end
         when chary='!@' then do
             tempfile.0 = tempfile.0+1
             h= tempfile.0
             call parseFileStringSUBR selectedFilesSTR.side
             tempDir = value( 'TEMP',, 'OS2ENVIRONMENT')
             if tempDir = '' then tempDir = value( 'TMP',, 'OS2ENVIRONMENT')
             if tempDir = '' then tempDir = 'C:'
             tempDir = strip( tempDir,'T','\')
             tempfile.h = SysTempFileName( tempDir||'\????Larc.tmp')
             do i=1 to FR.selected.0
                call lineout tempfile.h, FR.selected.i
             end
             call lineout tempfile.h
             if taggedBOOL then call taggedAllSUBR tempfile.h
             else menu.Nr.p = menu.Nr.p||tempfile.h
             nach = substr(nach, insPos+2)
         end
         when chary='!t' then do
             if alltaggedside ='opposide' then do
                taggedBOOL =0
                nach =''
                menu.Nr.p ='echo    -rxExec- ERROR: mixed y-Y t-T not possible.'
             end
             else do
                alltaggedside ='side'
                call parseFileStringSUBR selectedFilesSTR.side, 1
                if taggedBOOL then call taggedAllSUBR 'ALL_TAGGED'
                else do
                   taggedBOOL =1
                   do t=1 to FR.selected.0
                      menu.Nr.p.tagged.0=t
                      menu.Nr.p.tagged.t=menu.Nr.p||FR.selected.t
                   end
                end
                nach = substr(nach, insPos+2)
             end
         end
         when chary='!T' then do
             if alltaggedside ='side' then do
                taggedBOOL =0
                nach =''
                menu.Nr.p ='echo   -rxExec- ERROR: mixed y-Y t-T not possible.'
             end
             else do
                alltaggedside ='opposide'
                call parseFileStringSUBR selectedFilesSTR.opposide, 1
                if taggedBOOL then call taggedAllSUBR 'ALL_TAGGED'
                else do
                   taggedBOOL =1
                   do t=1 to FR.selected.0
                      menu.Nr.p.tagged.0=t
                      menu.Nr.p.tagged.t=menu.Nr.p||FR.selected.t
                   end
                end
                nach = substr(nach, insPos+2)
             end
         end
         when chary='!y' then do
             if alltaggedside ='opposide' then do
                taggedBOOL =0
                nach =''
                menu.Nr.p ='echo   -rxExec- ERROR: mixed y-Y t-T not possible.'
             end
             else do
                alltaggedside ='side'
                call parseFileStringSUBR selectedFilesSTR.side ,1
                if taggedBOOL then call taggedAllSUBR 'ALL_TAGGED_Y'
                else do
                   taggedBOOL =1
                   do t=1 to FR.selected.0
                      lpos = lastpos('.', FR.selected.t)
                      if lpos>1 then curfileNoExt = substr(FR.selected.t,1,lpos-1)
                      else curfileNoExt = FR.selected.t
                      menu.Nr.p.tagged.t=menu.Nr.p||curfileNoExt
                      menu.Nr.p.tagged.0=t
                   end
                end
                nach = substr(nach, insPos+2)
             end
         end
         when chary='!Y' then do
             if alltaggedside ='side' then do
                taggedBOOL =0
                nach =''
                menu.Nr.p ='echo   -rxExec- ERROR: mixed y-Y t-T not possible.'
             end
             else do
                alltaggedside ='opposide'
                call parseFileStringSUBR selectedFilesSTR.opposide, 1
                if taggedBOOL then call taggedAllSUBR 'ALL_TAGGED_Y'
                else do
                   taggedBOOL =1
                   do t=1 to FR.selected.0
                      lpos = lastpos('.', FR.selected.t)
                      if lpos>1 then curfileNoExt = substr(FR.selected.t,1,lpos-1)
                      else curfileNoExt = FR.selected.t
                      menu.Nr.p.tagged.t=menu.Nr.p||curfileNoExt
                      menu.Nr.p.tagged.0=t
                   end
                end
                nach = substr(nach, insPos+2)
             end
         end
         when chary=='!l' |chary=='!L' then do
             if chary=='!L' then sydy=opposide ; else sydy=side
             if taggedBOOL then call taggedAllSUBR parseFileStringSUBR(selectedFilesSTR.sydy, 1)
             else menu.Nr.p = menu.Nr.p || parseFileStringSUBR( selectedFilesSTR.sydy, 1)
             nach = substr(nach, insPos+2)
         end
         when chary='!i' then do
             input = input +1
             call SysCurPos zeile, 0
             antw =rxanswerCmdSUBR( input'. Input: ')
             if taggedBOOL then call taggedAllSUBR antw
             else menu.Nr.p = menu.Nr.p||antw
             nach = substr(nach, insPos+2)
         end
         when chary='!x' then do
             lpos = lastpos('.', filespec('N',pathCurfileN))
             if lpos>1 then curfileNoExt = substr( filespec('N',pathCurfileN), 1, lpos-1)
             else curfileNoExt = filespec( 'N', pathCurfileN)
             if taggedBOOL then call taggedAllSUBR curfileNoExt
             else menu.Nr.p = menu.Nr.p||curfileNoExt
             nach = substr(nach, insPos+2)
         end
         when left(chary,1)='!' then do
             if taggedBOOL then call taggedAllSUBR filespec('N',pathCurfileN)
             else menu.Nr.p = menu.Nr.p||filespec('N',pathCurfileN)
             nach = substr(nach, insPos+1)
         end
         otherwise do
             if taggedBOOL then call taggedAllSUBR nach
             else menu.Nr.p = menu.Nr.p||nach
             nach =''
         end
      end
      insPos = pos('!', nach)
   end
   if \taggedBOOL then call CommandLineSUBR strip( menu.Nr.p)
   else do
      say ; call charout , left( RC timeDisplay '['directory()'> 'Pnew_cmd, spalte)
/*    address 'CMD' '@echo off' */
      do t=1 to menu.Nr.p.tagged.0
         call CommandLineSUBR strip( menu.Nr.p.tagged.t)
      end
/*    address 'CMD' cmdEcho */
   end
   new_cmd = strip( Pnew_cmd)
   side    = old_side
   do h=1 to tempfile.0 ; call SysFileDelete tempfile.h ; end
return 0

taggedAllSUBR:
   parse arg next
   if next = 'ALL_TAGGED' then do t=1 to FR.selected.0
      menu.Nr.p.tagged.t =menu.Nr.p.tagged.t||FR.selected.t
   end
   else if next = 'ALL_TAGGED_Y' then do t=1 to FR.selected.0
      lpos = lastpos('.', FR.selected.t)
      if lpos>1 then curfileNoExt = substr(FR.selected.t,1,lpos-1)
      else curfileNoExt = FR.selected.t
      menu.Nr.p.tagged.t =menu.Nr.p.tagged.t ||curfileNoExt
   end
   else do t=1 to menu.Nr.p.tagged.0
      menu.Nr.p.tagged.t = menu.Nr.p.tagged.t||next
   end
return 0

rxanswerCmdSUBR:
   parse arg Message, antwort
   upDownBOOL=0
   if overstrikeBOOL<>1 then overstrikeBOOL=0
   firstRow = zeile
   firstCol = 0
   antw.0   = length( antwort)
   charN    = antw.0+1
   do i=1 to antw.0; antw.i= substr( antwort,i,1); end
   neuScreenBOOL=1
   do until chary=KB.retnK | chary=KB.escpK
      lenMess =length( Message)
      do until lenMess+antw.0 <= lenScreen
         lenScreen = ((zeile+1) * spalte)-((firstRow*spalte)+firstCol+1)
         if lenScreen < lenMess+antw.0 then do
            firstRow = firstRow -1
            lenScreen = ((zeile+1) * spalte)-((firstRow*spalte)+firstCol+1)
            call SysCurPos zeile, 0
            say
         end
      end
      if neuScreenBOOL then do
         antwort =''
         do i=1 to antw.0; antwort=antwort||antw.i; end
         call SysCurPos firstRow, firstCol
         call charout ,Message||antwort||copies(' ',lenScreen-(lenMess+antw.0))
      end
      else neuScreenBOOL=1
      scr =(firstRow*spalte)+firstCol+lenMess+charN-1
      call SysCurPos scr%spalte, scr//spalte
      call SysCurState 'On'
      chary = SysGetKey('NoEcho')
      if chary='E0'x|chary='00'x then chary =chary||SysGetKey('NoEcho')
      call SysCurState 'Off'
      select
         when chary = KB.retnK   then NOP
         when chary = KB.escpK   then antwort=''
         when chary = KB.C_O     then RETURN chary
         when chary = KB.F10     then RETURN chary
         when chary = KB.S_F3    then RETURN chary
         when chary = KB.F9      then RETURN chary
         when chary = KB.C_E     then call LSet
         when chary = KB.C_F1    then call Lsubject
         when chary = KB.A_0     then call cmdInsertSUBR alt_0
         when chary = KB.A_1     then call cmdInsertSUBR alt_1
         when chary = KB.A_2     then call cmdInsertSUBR alt_2
         when chary = KB.A_3     then call cmdInsertSUBR alt_3
         when chary = KB.A_4     then call cmdInsertSUBR alt_4
         when chary = KB.A_5     then call cmdInsertSUBR alt_5
         when chary = KB.A_6     then call cmdInsertSUBR alt_6
         when chary = KB.A_7     then call cmdInsertSUBR alt_7
         when chary = KB.A_8     then call cmdInsertSUBR alt_8
         when chary = KB.A_9     then call cmdInsertSUBR alt_9
         when chary = KB.C_F     then call cmdInsertSUBR pathCurfileN
         when chary = KB.C_T     then call cmdInsertSUBR parseFileStringSUBR( selectedFilesSTR.side,1)
         when chary = KB.C_retnK then call cmdInsertSUBR filespec('N', pathCurfileN)
         when chary = KB.C_0     then C_numDir_0.side =GonumDirSUBR( 0, C_numDir_0.side)
         when chary = KB.C_1     then C_numDir_0.side =GonumDirSUBR( 1, C_numDir_0.side)
         when chary = KB.C_2     then C_numDir_0.side =GonumDirSUBR( 2, C_numDir_0.side)
         when chary = KB.C_3     then C_numDir_0.side =GonumDirSUBR( 3, C_numDir_0.side)
         when chary = KB.C_4     then C_numDir_0.side =GonumDirSUBR( 4, C_numDir_0.side)
         when chary = KB.C_5     then C_numDir_0.side =GonumDirSUBR( 5, C_numDir_0.side)
         when chary = KB.C_6     then C_numDir_0.side =GonumDirSUBR( 6, C_numDir_0.side)
         when chary = KB.C_7     then C_numDir_0.side =GonumDirSUBR( 7, C_numDir_0.side)
         when chary = KB.C_8     then C_numDir_0.side =GonumDirSUBR( 8, C_numDir_0.side)
         when chary = KB.C_9     then C_numDir_0.side =GonumDirSUBR( 9, C_numDir_0.side)
         when chary = KB.C_X     then actcmd = X_HistorySUBR()
         when chary = KB.A_F8    then RETURN HistoryMenuSUBR()
         when chary = KB.leftK then do
            if charN>1 then charN = charN -1
            neuScreenBOOL=0
         end
         when chary = KB.rghtK then do
            if charN <= antw.0 then charN=charN+1
            neuScreenBOOL=0
         end
         when chary = KB.homek|chary=KB.C_homek|chary=KB.A_leftK then do
            charN = 1
            neuScreenBOOL=0
         end
         when chary = KB.endeK|chary=KB.C_endeK|chary=KB.A_rghtK then do
            charN = antw.0+1
            neuScreenBOOL=0
         end
         when chary=KB.C_leftK then do
            do i= charN-2 to 1 by -1; if antw.i = ' ' then leave i;end
            if i<1 then charN=1; else charN=i
            neuScreenBOOL=0
         end
         when chary=KB.C_rghtK then do
            do i=charN+2 to antw.0; if antw.i= ' ' then leave i;end
            if i>antw.0 then charN = antw.0+1
            else charN = i
            neuScreenBOOL=0
         end
         when chary = KB.A_F7 then do
               this = rxLarc( 'FIND', 0, ' -rxExec-    RETURN:  get name')  /* godirBOOL=0 */
               if this<>0 then call cmdInsertSUBR this
         end
         when chary=KB.A_F10|chary=KB.S_F10 then do
            if chary=KB.A_F10 then maxLev='-88'               ;else maxLev ='-2'
            if chary=KB.S_F10 then old_Dir=left(directory(),3);else old_Dir=''
            call LD old_Dir maxLev
            Message =RC timeDisplay '['directory()'>'
         end
         when chary=KB.C_F10 then do
            address 'CMD' '@start LD.cmd' left(directory(),3) '-S -9'
         end
         when chary = KB.A_retnK then do
               antwort = strip(antwort)
               parse var A_execOpt startx rest
               if 'START'= translate(startx) then do
                  if words(antwort)>0 then do
                     parse var antwort firsty restantw
                     antwort = 'Start "'firsty'"' rest '"'antwort'"'
                  end
                  else antwort = 'Start "a_Start_rxEcex"' rest '"'antwort'"'
               end
               else antwort = A_execOpt antwort
               chary = KB.retnK
         end
         when chary=KB.A_insK then do
               this = a_insertySUBR()
               call cmdInsertSUBR this
         end
         when chary=KB.C_insK then do
               this = antwort
               this = translate(this, ' ','|&')
               if this = '' then NOP
               else address 'CMD' '@echo 'this' |clipb -a'
         end
         when chary = KB.insK then do
               if overstrikeBOOL then overstrikeBOOL=0
               else overstrikeBOOL=1
         end
         when chary = KB.tabK then do
            old_Dir =  strip( directory(),'T','\') || '\'
            if old_Dir<>currD.side then c_numDir_0.side = old_Dir
            side = 1-side
            if length( currD.side )<4 then callDir = currD.side
            else callDir = strip(currD.side,'T','\')
            call directory callDir
            Message =RC timeDisplay '['directory()'>'
         end
         when chary=KB.upK then do
                  actcmd=actcmd-1
                  if actcmd<1 then actcmd =oldcommand.0+1
                  antwort = ' '||oldcommand.actcmd
                  antw.0 = length(antwort)
                  do i=1 to antw.0 ; antw.i= substr( antwort,i,1); end
                  charN=antw.0+1
         end
         when chary=KB.A_upK then do
               h = actcmd-1
               if h<1 then do
                  actcmd =oldcommand.0+1
                  h = actcmd-1
               end
               newKey = translate( left( strip(antwort), 1))
               do h=h to 1 by -1
                  if newKey = translate( left( oldcommand.h, 1)) then do
                     antwort = ' '||oldcommand.h
                     antw.0 = length(antwort)
                     do i=1 to antw.0 ; antw.i= substr( antwort,i,1); end
                     charN=antw.0+1
                     actcmd = h
                     leave h
                  end
               end
         end
         when chary=KB.downK then do
                  actcmd =actcmd+1
                  if actcmd> oldcommand.0+1 then actcmd=1
                  antwort = ' '||oldcommand.actcmd
                  antw.0 = length(antwort)
                  do i=1 to antw.0 ; antw.i= substr( antwort,i,1); end
                  charN=antw.0+1
         end
         when chary=KB.A_downK then do
               h = actcmd+1
               if h>oldcommand.0 then do
                  actcmd =1
                  h = 1
               end
               newKey = translate( left( strip(antwort), 1))
               do h=h to oldcommand.0
                  if newKey = translate( left( oldcommand.h, 1)) then do
                     antwort = ' '||oldcommand.h
                     antw.0 = length(antwort)
                     do i=1 to antw.0 ; antw.i= substr( antwort,i,1); end
                     charN=antw.0+1
                     actcmd = h
                     leave h
                  end
               end
         end
         when chary=KB.delK then do
            if charN <= antw.0 then do
               do j=charN to antw.0 ; h=j+1; antw.j=antw.h; end
               antw.0 = antw.0-1
            end
         end
         when chary=KB.C_delK then do
            if charN <= antw.0 then do y=1 to antw.0
               if charN>antw.0 then leave y
               do j=charN to antw.0 ; h=j+1; antw.j=antw.h; end
               antw.0 = antw.0-1
               if antw.charN='20'x then leave y
            end
         end
         when chary = KB.bkspK then do
            if charN > 1 then do
               charN = charN-1
               do j=charN to antw.0; h=j+1; antw.j=antw.h; end
               antw.0 = antw.0 -1
            end
         end
         when chary = KB.C_bkspK then do
            do y=1 to antw.0
               if charN=1 then leave y
               charN = charN-1
               antw.0 = antw.0 -1
               if antw.charN==' ' then do
                  do j=charN to antw.0; h=j+1; antw.j=antw.h; end
                  leave y
               end
               do j=charN to antw.0; h=j+1; antw.j=antw.h; end
            end
         end
         when overstrikeBOOL=0 then do
               chary = right( chary,1)
               antw.0 = antw.0+1; h = antw.0+1; antw.h = ' '
               do j=antw.0 to charN+1 by -1; h=j-1; antw.j=antw.h; end
               antw.charN = chary
               charN = charN + 1
         end
         when overstrikeBOOL=1 then do
               chary = right( chary,1)
               antw.charN = chary
               call charout, antw.charN
               if charN > antw.0 then antw.0=charN
               charN = charN + 1
         end
         otherwise NOP
      end /* select */
   end
return antwort

a_insertySUBR:
      address 'CMD' '@clipb.exe -r | rxqueue'
      this = ''
      do x=1 to queued()
         parse pull some
         some = strip(some)
         if pos('00'x, some)=0 then this = this some
         if length( this ) > 800 then leave x
      end
return this

cmdInsertSUBR:
   parse arg this
   vor=''; nach=''
   posy = charN-1
   if posy>0 then parse var antwort vor +(posy) nach
   else nach= antwort
   antwort = vor||this||nach
   antw.0 = length(antwort)
   do i=1 to antw.0 ; antw.i= substr( antwort,i,1); end
   charN = charN+length( this)
return 0

parseFileStringSUBR:
   parse arg selString, stripBsBOOL
   if stripBsBOOL<>1 then stripBsBOOL=0
   u=0 ; allString=''
   do while selString <>''
      u=u+1
      parse var selString FR.selected.u '#' selString
      if stripBsBOOL & right( FR.selected.u,2)<>':\' then FR.selected.u = strip( FR.selected.u, 'T', '\')
      allString = allString FR.selected.u
      selString = strip( selString)
   end
   allString=strip(allString)
   FR.selected.0 =u
return allString

KBinitSUBR:
   KB.A_0     ='0081'x
   KB.A_1     ='0078'x
   KB.A_2     ='0079'x
   KB.A_3     ='007A'x
   KB.A_4     ='007B'x
   KB.A_5     ='007C'x
   KB.A_6     ='007D'x
   KB.A_7     ='007E'x
   KB.A_8     ='007F'x
   KB.A_9     ='0080'x
   KB.A_F10   ='0071'x
   KB.A_F7    ='006E'x
   KB.A_F8    ='006F'x
   KB.A_X     ='002D'x
   KB.A_downK ='00A0'x
   KB.A_insK  ='00A2'x
   KB.A_leftK ='009B'x
   KB.A_retnK ='001C'x
   KB.A_rghtK ='009D'x
   KB.A_upK   ='0098'x
   KB.C_0     ='0092'x
   KB.C_1     ='0075'x
   KB.C_2     ='0091'x
   KB.C_3     ='0076'x
   KB.C_4     ='0073'x
   KB.C_5     ='008F'x
   KB.C_6     ='0074'x
   KB.C_7     ='0077'x
   KB.C_8     ='008D'x
   KB.C_9     ='0084'x
   KB.C_E     ='05'x
   KB.C_F     ='06'x
   KB.C_F1    ='005E'x
   KB.C_F10   ='0067'x
   KB.C_O     ='0F'x
   KB.C_T     ='14'x
   KB.C_X     ='18'x
   KB.C_bkspK ='7F'x
   KB.C_delK  ='E093'x
   KB.C_endeK ='E075'x
   KB.C_homek ='E077'x
   KB.C_insK  ='E092'x
   KB.C_leftK ='E073'x
   KB.C_retnK ='0A'x
   KB.C_rghtK ='E074'x
   KB.F10     ='0044'x
   KB.F9      ='0043'x
   KB.S_F3    ='0056'x
   KB.S_F10   ='005D'x
   KB.bkspK   ='08'x
   KB.delK    ='E053'x
   KB.downK   ='E050'x
   KB.endeK   ='E04F'x
   KB.escpK   ='1B'x
   KB.homek   ='E047'x
   KB.insK    ='E052'x
   KB.leftK   ='E04B'x
   KB.retnK   ='0D'x
   KB.rghtK   ='E04D'x
   KB.tabK    ='09'x
   KB.upK     ='E048'x
return 0

rxinitSUBR:
   if firstReturnBOOL<>1  then firstReturnBOOL=0
   if directExeBOOL  <>1  then directExeBOOL  =0
   if cmdShortBOOL   <>1  then cmdShortBOOL   =0
   if timeit         ='R' then timeresetBOOL  =1
   if noHistoryBOOL  <>1  then noHistoryBOOL  =0
   if Echo_off_BOOL=1 then cmdEcho ='@echo off' ; else cmdEcho ='@echo on'
   address 'CMD' cmdEcho
   Ansi.norm  ='1B'x||'[0m';
   parse value SysTextScreenSize() with zeile spalte
   zeile = zeile-1
   oldcommand. =' '
   oldcommand.0 =0
   oldCmdQueue = 'OLD_CMD_Q'
   if timeresetBOOL<>1 then do ; timeit = 'L' ; timeresetBOOL=0 ; end
   timeDisplay = left( time( timeit),11)
   call SysCurState 'OFF'
   if side<>1 then side =0
   first_side = side
   new_cmd=''
   delHistMessageSTRING =' ? ESC/Space&Return     delete history?'
return 0

setLastLineSUBR:
   call SysCurPos zeile, 0
   call charout , copies(' ',79)||Ansi.norm
   call SysCurPos zeile-1, 79
return 0

outTxtSUBR:
   if outTxt<>'' then do ; call SysCurPos 0,0 ; call charout ,outTxt||copies(' ', 79) ; end
   call SysCurPos zeile, 0
return 0

RCshowSUBR:
   call SysCurPos zeile, 0
   say ' -rxExec- RC:' RC
return 0

GonumDirSUBR:
   parse arg num, Ctrl_numDir.0
   old_Dir = directory()
   if right( Ctrl_numDir.num,2) <> ':\' then Ctrl_numDir.num = strip( Ctrl_numDir.num , 'T', '\')
   call directory Ctrl_numDir.num
   new_Dir = directory()
   if new_Dir<>old_Dir then Ctrl_numDir.0 = old_Dir
   Message =RC timeDisplay '['new_Dir'>'
   command=''
return Ctrl_numDir.0

