
#ifndef _LOCK_H
#define _LOCK_H

typedef void * LOCK;


#ifdef VFS 
void lock(LOCK, int, char*);
void unlock(LOCK, int, char*);

#define lock(x) lock(x, __LINE__, __FILE__)
#define unlock(x) unlock(x, __LINE__, __FILE__)

#endif

#if defined(USER) || defined(IFS)

void lock(LOCK);
void unlock(LOCK);

#endif


#define lockcatrec(crptr) (lock((crptr)->locked))
#define unlockcatrec(crptr) (unlock((crptr)->locked))

LOCK make_lock(void);
void unmake_lock(LOCK);

/* you should always assign to a lock with make_lock() before using
the lock() and unlock() functions.  Use unmake_lock() when you won't
be using the lock anymore.  make_lock() implies a malloc;
unmake_lock() implies a free(). */

#endif /* _LOCK_H */