(* This exit procedure may be used to trap HALT codes.	If defined in the
	 main body of your program (DoorExit := TrapExit), this procedure will be
	 called whenever your program encounters a HALT code or runtime error.

	 As shown below, if ErrorAddr <> NIL (no runtime error has occurred) the
	 runtime error information is displayed to the local console and is also
	 written to a file called PROG_ERR.LOG.  You may wish to change the name
	 of this error log file to something more fitting to your program.

	 If ErrorAddr = NIL then this code assumes that no runtime error has
	 occurred but rather that a HALT code has been encountered.  You could
	 conceivably handle all your HALT functions within the TRAPEXIT procedure.
	 However, in this demonstration, we can see that we are passing the HALT
	 code onto the TERMINATE procedure which is located within your program's
	 code.
*)


(* Converts a word into a 4 CHAR hex number *)
FUNCTION itoh(w: WORD) : STRING;
	CONST
		hex : ARRAY[0..15] OF CHAR = '0123456789ABCDEF';
	VAR
		h : STRING[4];
	BEGIN
		h[0] := CHR(4);
		h[1] := hex[(w SHR 12) AND $0f];
		h[2] := hex[(w SHR 8) AND $0f];
		h[3] := hex[(w SHR 4) AND $0f];
		h[4] := hex[w AND $0f];
		itoh := h;
	END;


FUNCTION error_message(code : INTEGER) : STRING;
	VAR
		classtype :  STRING;
		msg : STRING;
	BEGIN
		CASE code OF
				1.. 99	: classtype := 'DOS ERROR : ';
				100..149: classtype := 'I/O ERROR : ';
				150..199: classtype := 'CRITICAL ERROR : ';
				200..249: classtype := 'FATAL ERROR : ';
			ELSE
				classtype := 'UNKNOWN ERROR : ';
		END;

	CASE code OF
			2: msg := 'File not found';
			3: msg := 'Path not found';
			4: msg := 'Too many open files';
			5: msg := 'File access denied';
			6: msg := 'Bad file handle';
			12: msg := 'Bad file access code';
			15: msg := 'Bad drive number';
			16: msg := 'Can''t remove current dir';
			17: msg := 'Can''t rename across drives';
			100: msg := 'Disk read error, read past eof on Typed File';
			101: msg := 'Disk write error';
			102: msg := 'File not assigned';
			103: msg := 'File not open';
			104: msg := 'File not open for input';
			105: msg := 'File not open for output';
			106: msg := 'Bad numeric format';
			150: msg := 'Disk is write-protected';
			151: msg := 'Unknown diskette unit';
			152: msg := 'Drive not ready';
			153: msg := 'Unknown command';
			154: msg := 'CRC error in data';
			155: msg := 'Bad drive request structure length';
			156: msg := 'Disk seek error';
			157: msg := 'Unknown diskette type';
			158: msg := 'Sector not found';
			159: msg := 'Printer out of paper';
			160: msg := 'Device write fault';
			161: msg := 'Device read fault';
			162: msg := 'Hardware failure';
			200: msg := 'Division by zero';
			201: msg := 'Range check';
			202: msg := 'Stack overflow';
			203: msg := 'Heap overflow'+' (Not enough memory to run)';
			204: msg := 'Bad pointer operation';
			205: msg := 'Floating point overflow';
			206: msg := 'Floating point underflow';
			207: msg := 'Bad floating point operation';
		ELSE
			STR(code, msg);
		END;
	error_message := classtype + msg;
END;


FUNCTION Exit_message(Code: INTEGER): STRING;
		 {return message text for a given exit code}
	VAR
		msg:		STRING;
	BEGIN
		CASE Code OF
				0: msg := 'Normal Termination';
				1: msg := 'Carrier Lost';
				2: msg := 'Time Limit Exceeded';
				3: msg := 'User Inactivity Timeout';
				4:
						IF doorsys THEN
							msg := 'Door.Sys file not found'
						ELSE IF sessioninfo THEN
							msg := 'Session.Info file not found'
						ELSE
							msg := 'Dorinfo' + itoa(getnode) + '.Def file not found';
				5: msg := 'Cannot Find ExitInfo.Bbs';
				6: msg := 'Directory Change/Read Error';
				7: msg := 'CTS Timeout';
				8: msg := 'Forced Exit via RAXIT Semaphore';
				9: msg := 'File Lock Timeout';
				10:msg := 'User Logged Off';
				255: msg := 'Sysop Hit Ctrl-Break!';
			ELSE
				STR(Code,msg);
		END;
	exit_message := msg;
END;


PROCEDURE hdr_errfile(VAR f : TEXT);
	BEGIN
		REWRITE(f) ;
		WRITELN(f, 'Error Log Generated by ', productname,' On Node ' + itoa(getnode));
		WRITELN(f);
	END;


PROCEDURE trapexit; FAR;
	VAR
		errfile : TEXT;
	BEGIN
		bv_Log('Trapexit Begin');
		IF ERRORADDR = NIL THEN
			BEGIN
				IF (EXITCODE IN [0, 10, 255]) THEN
					BEGIN
						terminate(EXITCODE) ;
						EXIT;
					END;
				ASSIGN(errfile, ckpath(exepath) + bvlogname + itoa(getnode) +'.Err') ;
				{$I-}
				APPEND(errfile);
				{$I+}
				IF IORESULT <> 0 then
					hdr_errfile(errfile);
				WRITELN(errfile, ' ! ',datestr,'  ', timestr,'   ' + exit_message(EXITCODE));
				FLUSH(errfile) ;
				CLOSE(errfile) ;
				terminate(EXITCODE);
			END
		ELSE
			BEGIN
				ASSIGN(errfile, ckpath(exepath) + bvlogname + itoa(getnode)+'.Log') ;
				WRITELN('ERROR!!  Read ', ckpath(exepath) + bvlogname + itoa(getnode) + '.Log for more information');
				{$I-}
				APPEND(errfile);
				{$I+}
				IF IORESULT <> 0 THEN
					hdr_errfile(errfile);
				WRITE(errfile, ' ! ',datestr,'  ',timestr,'   Error : ', itoa(EXITCODE),' @ ',itoa(SEG(ERRORADDR^)));
				WRITELN(errfile, ':', itoa(OFS(ERRORADDR^)));
				WRITE(' ! ',datestr,'  ',timestr,'   ', error_message(EXITCODE));
				WRITELN(errfile);
				FLUSH(errfile);
				CLOSE(errfile);
			END;
	erroraddr := NIL;
END;
