/*
 *      FRATE.CMD - V1.0 C.Langanke 1996
 *
 *      REXX sample for "Animated Mouse Pointer for OS/2"
 *
 *      Syntax: FRATE nnn [UNDEFINED|ALL] [/?]
 *
 *      FRATE sets the default timeframe value and determines for which
 *      pointer images of your animations it is to be used.
 *
 *      nnn            is the timeframe value in msecs in the
 *                     range from 100 to 2000.
 *      ALL|UNDEFINED  means the timeframe value is used for all
 *                     pointer images or just for thos who do not define
 *                     timeframe values. Default: UNDEFINED.
 *
 *      /?             displays this help text.
 *
 *      NOTE: "Animated Mouse Pointer for OS/2" must be
 *            installed before executing this batch program.
 *
 *      Refer to WPAMPTR.INF for more information about how
 *      to use REXX setup strings to configure
 *      "Animated Mouse Pointer for OS/2"
 */
/* First comment is used as online help text. */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 /* OS/2 error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 /* show help */
 ARG Parm .
 IF ((Parm = '') | (POS('?', Parm) > 0)) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* get parms */
 ARG framerate AllFlag

 /* verify commandline parms */
 IF (DATATYPE(framerate) \= 'NUM') THEN
 DO
    SAY CmdName': error: timframe value parameter must be numeric.';
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 IF ((framerate < 100) | (framerate > 2000)) THEN
 DO
    SAY CmdName': error: timframe value parameter bust be in the range from 100 to 2000.';
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 SELECT
    WHEN (POS(AllFlag, 'UNDEFINED') = 1) THEN AllFlag    = 'UNDEFINED';
    WHEN (POS(AllFlag, 'ALL') = 1)       THEN AllFlag    = 'ALL';
    OTHERWISE                                 AllFlag    = 'UNDEFINED';
 END;

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* now setup the mouse object */
 setup    = 'FRAMELENGTH='STRIP(framerate)','AllFlag';';

 CALL CHAROUT, 'setup mouse object with "'setup'"   ... ';
 rc = SysSetObjectData( '<WP_MOUSE>', setup);
 IF (rc = 1) THEN
    SAY 'Ok.';
 ELSE
    SAY 'ERROR !';

 EXIT(ERROR.NO_ERROR);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE Title

 SAY;
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* close file again */
 rc = LINEOUT(Thisfile);

 RETURN('');

