#define IRP_IO(x)    (pIrpThis->Parameters.DeviceIoControl.x)
#define IRP_READ(x)  (pIrpThis->Parameters.Read.x)
#define IRP_WRITE(x) (pIrpThis->Parameters.Write.x)
#define IRP_FILE(x)  (pIrpThis->FileObject->FileName.x)
#define IoGetMethodCodeFromCtlCode(x) ((x) & 0x00000003)

// -----------------------------------------------------------------

NTSTATUS SpyFilterBegin (PDEVICE_OBJECT pDeviceObject,
                         PIRP           pIrp,
                         PVOID          pContext)
    {
    PCONTROL_CONTEXT   pControlContext;
    PIO_STACK_LOCATION pIrpThis;
    PVOID              pInput;
    DWORD              dInput, dFunction, dSubFunction;
    DWORD              dIoCode, dIoMethod, dIoFunction;
    PSTR               psFunction, psSubFunction, psIoFunction;
    PSTR               psIoMethod;

    pControlContext = pControlDevice->DeviceExtension;
    pIrpThis        = IoGetCurrentIrpStackLocation (pIrp);
    dFunction       = pIrpThis->MajorFunction;
    dSubFunction    = pIrpThis->MinorFunction;

    GetFunctionName (dFunction,   dSubFunction,
                     &psFunction, &psSubFunction);

    Out (pControlContext, "\nFunction:   %4u", dFunction);
    if (psFunction != NULL)
        {
        Out (pControlContext, " = %a", psFunction);
        }
    Out (pControlContext, "\nSubfunction:%4u", dSubFunction);
    if (psSubFunction != NULL)
        {
        Out (pControlContext, " = %a", psSubFunction);
        }
    Out (pControlContext, "\n");

    pInput     = NULL;
    psIoMethod = NULL;

    switch (dFunction)
        {
        case IRP_MJ_CREATE:

            if (IRP_FILE (Length))
                {
                Out (pControlContext,
                     "\n   Open/create file object \"%w\"\n",
                     IRP_FILE (Buffer));
                }
            else
                {
                Out (pControlContext,
                     "\n   Open device object\n");
                }
            break;

        case IRP_MJ_WRITE:

            psIoMethod  = "   Unknown";
            dInput      = IRP_WRITE (Length);
            dIoMethod   = pFilterDevice->Flags &
                          (DO_BUFFERED_IO | DO_DIRECT_IO);

            switch (dIoMethod)
                {
                case DO_BUFFERED_IO:

                    pInput     = pIrp->AssociatedIrp.SystemBuffer;
                    psIoMethod = "  Buffered";
                    break;

                case DO_NEITHER_IO:

                    pInput     = pIrp->UserBuffer;
                    psIoMethod = "Unbuffered";
                    break;
                
                case DO_DIRECT_IO:

                    psIoMethod = "Direct Out";
                    break;
                }
            break;

        case IRP_MJ_DEVICE_CONTROL:
        case IRP_MJ_INTERNAL_DEVICE_CONTROL:
        case IRP_MJ_FILE_SYSTEM_CONTROL:

            psIoMethod  = "   Unknown";
            dInput      = IRP_IO (InputBufferLength);
            dIoCode     = IRP_IO (IoControlCode);
            dIoFunction = IoGetFunctionCodeFromCtlCode (dIoCode);
            dIoMethod   = IoGetMethodCodeFromCtlCode   (dIoCode);

            switch (dIoMethod)
                {
                case METHOD_BUFFERED:

                    pInput     = pIrp->AssociatedIrp.SystemBuffer;
                    psIoMethod = "  Buffered";
                    break;

                case METHOD_NEITHER:

                    pInput     = IRP_IO (Type3InputBuffer);
                    psIoMethod = "Unbuffered";
                    break;

                case METHOD_IN_DIRECT:

                    psIoMethod = " Direct In";
                    break;

                case METHOD_OUT_DIRECT:

                    psIoMethod = "Direct Out";
                    break;
                }
            Out (pControlContext,
                 "\n   I/O control code:    0x%08h",
                 dIoCode);

            Out (pControlContext,
                 "\n   I/O function code:        0x%03h",
                 dIoFunction);

            GetIoFunctionName (dIoFunction, &psIoFunction);
            if (psIoFunction != NULL)
                {
                Out (pControlContext, " = %a", psIoFunction);
                }
            Out (pControlContext, "\n");

            break;
        }
    if (psIoMethod != NULL)
        {
        Out (pControlContext,
             "\n   I/O transfer type:   %a",
             psIoMethod);

        Out (pControlContext,
             "\n   Input buffer size:   %10u\n",
             dInput);

        if ((pInput != NULL) && dInput)
            {
            Out (pControlContext,
                 "   Input buffer base:   0x%08h\n",
                 pInput);

            Dump (pControlContext, "\n", pInput, dInput, 0);
            }
        }
    return STATUS_SUCCESS;
    }

// -----------------------------------------------------------------

NTSTATUS SpyFilterEnd (PDEVICE_OBJECT pDeviceObject,
                       PIRP           pIrp,
                       PVOID          pContext)
    {
    PCONTROL_CONTEXT   pControlContext;
    PIO_STACK_LOCATION pIrpThis;
    PVOID              pOutput;
    DWORD              dOutput, dReturned, dFunction, dSubFunction;
    DWORD              dIoCode, dIoMethod;
    PSTR               psIoMethod;

    pControlContext = pControlDevice->DeviceExtension;
    pIrpThis        = IoGetCurrentIrpStackLocation (pIrp);
    dFunction       = pIrpThis->MajorFunction;
    dSubFunction    = pIrpThis->MinorFunction;

    pOutput    = NULL;
    psIoMethod = NULL;

    switch (dFunction)
        {
        case IRP_MJ_READ:

            psIoMethod  = "   Unknown";
            dOutput     = IRP_READ (Length);
            dIoMethod   = pFilterDevice->Flags &
                          (DO_BUFFERED_IO | DO_DIRECT_IO);

            switch (dIoMethod)
                {
                case DO_BUFFERED_IO:

                    pOutput    = pIrp->AssociatedIrp.SystemBuffer;
                    psIoMethod = "  Buffered";
                    break;

                case DO_NEITHER_IO:

                    pOutput    = pIrp->UserBuffer;
                    psIoMethod = "Unbuffered";
                    break;
                
                case DO_DIRECT_IO:

                    psIoMethod = "Direct Out";
                    break;
                }
            break;

        case IRP_MJ_DEVICE_CONTROL:
        case IRP_MJ_INTERNAL_DEVICE_CONTROL:
        case IRP_MJ_FILE_SYSTEM_CONTROL:

            psIoMethod = "   Unknown";
            dOutput    = IRP_IO (OutputBufferLength);
            dIoCode    = IRP_IO (IoControlCode);
            dIoMethod  = IoGetMethodCodeFromCtlCode (dIoCode);

            switch (dIoMethod)
                {
                case METHOD_BUFFERED:

                    pOutput    = pIrp->AssociatedIrp.SystemBuffer;
                    psIoMethod = "  Buffered";
                    break;

                case METHOD_NEITHER:

                    pOutput    = pIrp->UserBuffer;
                    psIoMethod = "Unbuffered";
                    break;

                case METHOD_IN_DIRECT:

                    psIoMethod = " Direct In";
                    break;

                case METHOD_OUT_DIRECT:

                    psIoMethod = "Direct Out";
                    break;
                }
            break;
        }
    if (psIoMethod != NULL)
        {
        dReturned = pIrp->IoStatus.Information;

        Out (pControlContext,
             "\n   I/O transfer type:   %a",
             psIoMethod);

        Out (pControlContext,
             "\n   Output buffer size:  %10u",
             dOutput);

        Out (pControlContext,
             "\n   Output packet size:  %10u\n",
             dReturned);

        if ((pOutput != NULL) && dOutput)
            {
            Out (pControlContext,
                 "   Output buffer base:  0x%08h\n",
                 pOutput);

            Dump (pControlContext, "\n", pOutput, dReturned, 0);
            }
        }
    Out (pControlContext,
         "\nRequest status = 0x%08h"
         "\nRequest info   = %10u\n",
         pIrp->IoStatus.Status,
         pIrp->IoStatus.Information);

    return STATUS_SUCCESS;
    }

// -----------------------------------------------------------------

NTSTATUS SpyFilterExit (PDEVICE_OBJECT pDeviceObject,
                        PIRP           pIrp,
                        PVOID          pContext)
    {
    if (pIrp->PendingReturned)
        {
        IoMarkIrpPending (pIrp);
        }
    else
        {
        SpyFilterEnd (pDeviceObject, pIrp, pContext);
        }
    return pIrp->IoStatus.Status;
    }

// -----------------------------------------------------------------

NTSTATUS SpyFilter (PDEVICE_OBJECT pDeviceObject,
                    PIRP           pIrp,
                    PVOID          pContext)
    {
    PFILTER_CONTEXT    pFilterContext;
    PIO_STACK_LOCATION pIrpThis, pIrpNext;

    pFilterContext = pDeviceObject->DeviceExtension;
    pIrpThis       = IoGetCurrentIrpStackLocation (pIrp);
    pIrpNext       = IoGetNextIrpStackLocation (pIrp);

    SpyFilterBegin (pDeviceObject, pIrp, pContext);

    *pIrpNext = *pIrpThis;

    IoSetCompletionRoutine (pIrp,
                            SpyFilterExit,
                            pContext,
                            TRUE,
                            TRUE,
                            TRUE);
    
    return IoCallDriver (pFilterContext->pTargetDevice, pIrp);
    }


