
// ComSpy.h
// 11-16-1996 Sven B. Schreiber
// 100557.177@compuserve.com

// =================================================================
// MACROS
// =================================================================

#define IRP_IO(x) (pIrpThis->Parameters.DeviceIoControl.x)
#define IRP_READ(x) (pIrpThis->Parameters.Read.x)
#define IRP_WRITE(x) (pIrpThis->Parameters.Write.x)
#define IRP_FILE(x) (pIrpThis->FileObject->FileName.x)
#define IoGetMethodCodeFromCtlCode(x) ((x) & 0x00000003)

// =================================================================
// CONSTANTS
// =================================================================

#define SPY_BUFFER_SIZE 0x100000

#define FILE_DEVICE_SPY_CONTROL 0x8000
#define DO_NEITHER_IO           0

#define IOCTL_NWRDR_NCP         0x400

#define IOCTL_INFO  CTL_CODE (FILE_DEVICE_SPY_CONTROL, \
                              0x0800, \
                              METHOD_BUFFERED, \
                              FILE_READ_ACCESS)

#define IOCTL_RESET CTL_CODE (FILE_DEVICE_SPY_CONTROL, \
                              0x0801, \
                              METHOD_BUFFERED, \
                              FILE_WRITE_ACCESS)

#define IOCTL_READ  CTL_CODE (FILE_DEVICE_SPY_CONTROL, \
                              0x0802, \
                              METHOD_BUFFERED, \
                              FILE_READ_ACCESS)

#define IOCTL_WRITE CTL_CODE (FILE_DEVICE_SPY_CONTROL, \
                              0x0803, \
                              METHOD_BUFFERED, \
                              FILE_WRITE_ACCESS)

// -----------------------------------------------------------------

#define IOCTL_SERIAL_SET_BAUD_RATE     1
#define IOCTL_SERIAL_SET_QUEUE_SIZE    2
#define IOCTL_SERIAL_SET_LINE_CONTROL  3
#define IOCTL_SERIAL_SET_BREAK_ON      4
#define IOCTL_SERIAL_SET_BREAK_OFF     5
#define IOCTL_SERIAL_IMMEDIATE_CHAR    6
#define IOCTL_SERIAL_SET_TIMEOUTS      7
#define IOCTL_SERIAL_GET_TIMEOUTS      8
#define IOCTL_SERIAL_SET_DTR           9
#define IOCTL_SERIAL_CLR_DTR          10
#define IOCTL_SERIAL_RESET_DEVICE     11
#define IOCTL_SERIAL_SET_RTS          12
#define IOCTL_SERIAL_CLR_RTS          13
#define IOCTL_SERIAL_SET_XOFF         14
#define IOCTL_SERIAL_SET_XON          15
#define IOCTL_SERIAL_GET_WAIT_MASK    16
#define IOCTL_SERIAL_SET_WAIT_MASK    17
#define IOCTL_SERIAL_WAIT_ON_MASK     18
#define IOCTL_SERIAL_PURGE            19
#define IOCTL_SERIAL_GET_BAUD_RATE    20
#define IOCTL_SERIAL_GET_LINE_CONTROL 21
#define IOCTL_SERIAL_GET_CHARS        22
#define IOCTL_SERIAL_SET_CHARS        23
#define IOCTL_SERIAL_GET_HANDFLOW     24
#define IOCTL_SERIAL_SET_HANDFLOW     25
#define IOCTL_SERIAL_GET_MODEMSTATUS  26
#define IOCTL_SERIAL_GET_COMMSTATUS   27
#define IOCTL_SERIAL_XOFF_COUNTER     28
#define IOCTL_SERIAL_GET_PROPERTIES   29
#define IOCTL_SERIAL_GET_DTRRTS       30

// =================================================================
// DATA TYPES
// =================================================================

typedef UCHAR  BYTE,  *PBYTE;
typedef USHORT WORD,  *PWORD;
typedef ULONG  DWORD, *PDWORD;
typedef ULONG  BOOL,  *PBOOL;

// -----------------------------------------------------------------

typedef struct _FILTER_INFO
    {
    DWORD dMajorVersion;
    DWORD dMinorVersion;
    DWORD dYear;
    DWORD dMonth;
    DWORD dDay;
    char  sDescription [50];
    char  sAuthor      [50];
    char  sEmail       [50];
    }
    FILTER_INFO, *PFILTER_INFO;

// -----------------------------------------------------------------

typedef struct _FILTER_CONTEXT
    {
    PDEVICE_OBJECT pTargetDevice;
    }
    FILTER_CONTEXT, *PFILTER_CONTEXT;

// -----------------------------------------------------------------

typedef struct _CONTROL_CONTEXT
    {
    DWORD dStatus;
    DWORD dRead;
    DWORD dWrite;
    BYTE  Data [SPY_BUFFER_SIZE];
    }
    CONTROL_CONTEXT, *PCONTROL_CONTEXT;

// =================================================================
// END OF FILE
// =================================================================
