/*
    File: Font.c
    Author: T Jayraman
    Date: September 18, 1996
*/

#include <windows.h>
#include <assert.h>
#include <string.h>
#include "font.h"

/*********************************************************/
//    Function:  CreateFontEx
//    Creates a font given a name and size 
//    Parameters : font name , size
//                 bool values for bold, italic
//                       underline and strikeout.
//      returns font handle on success, NULL otherwise.
/*********************************************************/

HFONT CreateFontEx (LPCSTR szFontName, int nSize,
    BOOL bBold, BOOL bItalic, BOOL bUnderline, BOOL bStrikeOut)
{
   LOGFONT lf;        
   HFONT hFont = NULL;
   HDC hScreenDC;
   int nRet;
   
   assert (szFontName);     // Invalid params ?
   assert (nSize);

   // get a device context (screen)
   hScreenDC = GetDC(NULL);
    assert (hScreenDC);
   
   nRet = EnumFontFamilies (hScreenDC, szFontName,
        (FONTENUMPROC)EnumFontFamProc, &lf);
   ReleaseDC(NULL, hScreenDC);
   
   // if the font is invalid nRet will have value 1 else 0
   if (nRet) 
        return NULL;
   
// Converts point size to logical font size for MM_TEXT only!
    lf.lfHeight =  -MulDiv (nSize, 
                GetDeviceCaps(hScreenDC, LOGPIXELSY), 72) ;

    lf.lfWidth = 0;     // Force Windows to use default width.
    lf.lfWeight =  bBold ? 700 : 400;   // Windows values
    lf.lfItalic =  bItalic;
    lf.lfUnderline = bUnderline;
    lf.lfStrikeOut = bStrikeOut;
    
   hFont = CreateFontIndirect (&lf);
   return hFont;
}         

/*********************************************************/
//  EnumFontFamProc - callback function
//    callback function where windows fills the value of
//    logfont structure
//  If called, return 0 to indicate that we have enough 
//  information and we don't want to be called again.
//  lParam - contains pointer to LOGFONT structure to fill.
/*********************************************************/   

int CALLBACK _export EnumFontFamProc (LOGFONT* lplf,
        NEWTEXTMETRIC* lpntm, int nFontType, LPARAM lParam)
{
    LOGFONT *lpLogFont = (LOGFONT *)lParam; // Extra param!
    assert (lpLogFont);
    memcpy (lpLogFont, lplf, sizeof (LOGFONT));  
   return 0;        // indicate that once is enough.
}

