#include "plugplay.h"
#include <windowsx.h>
#include <dbt.h>          /* PnP definitions */

#define PRG_NAME      "Plug-and-Play Demo"
#define GET_SIZE(h)   (IsDlgButtonChecked(h,IDC_640) \
                       ?MAKELONG(640,480) \
                       :IsDlgButtonChecked(h,IDC_800) \
                       ?MAKELONG(800,600) \
                       :MAKELONG(1024,768))
LRESULT CALLBACK APP_DlgProc( HWND, UINT, WPARAM, LPARAM );
VOID OnDeviceChange( HWND, UINT, DEV_BROADCAST_HDR FAR* );
VOID OnDisplayChange( HWND );
WORD GetCurrentBitsPerPel( HWND );

#ifdef __BORLANDC__
#   pragma argsused
#endif
INT APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrevious, 
                      LPSTR lpsz, INT iCmd )
{
   return DialogBox( hInstance, "DLG_MAIN", NULL, 
                     (DLGPROC)APP_DlgProc );
}

LRESULT CALLBACK APP_DlgProc( HWND hDlg, UINT uiMsg, 
                              WPARAM wParam, LPARAM lParam )
{
   switch( uiMsg )
   {
      case WM_INITDIALOG:
          CheckRadioButton( hDlg, IDC_640, IDC_1024, IDC_800 );
          break;

      case WM_DEVICECHANGE:
          OnDeviceChange( hDlg, (UINT)wParam, 
                         (DEV_BROADCAST_HDR FAR*)lParam );
          break;
      case WM_DISPLAYCHANGE:
          MessageBox( hDlg, "The screen size changed.", 
                      PRG_NAME, MB_ICONINFORMATION );
          break;
      case WM_COMMAND:
          switch( wParam )		    
          {
             case IDOK: 
                 OnDisplayChange( hDlg );
                 return 1;
             case IDCANCEL:
                 EndDialog( hDlg, FALSE );
                 return 0;
          }
          break;
	}
    return 0;
}

VOID OnDisplayChange( HWND hDlg )
{
    DEVMODE dm;
    DWORD dwSize = GET_SIZE(hDlg);
    ZeroMemory( &dm, sizeof(DEVMODE) );
    dm.dmSize = sizeof(DEVMODE);
    dm.dmPelsWidth = LOWORD(dwSize);
    dm.dmPelsHeight = HIWORD(dwSize);
    dm.dmBitsPerPel = GetCurrentBitsPerPel(hDlg);
    dm.dmFields |= DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
    ChangeDisplaySettings( &dm, 0 );
}

WORD GetCurrentBitsPerPel( HWND hDlg )
{
    WORD wBitsPerPel;
    HDC hDC = GetDC( hDlg );
    wBitsPerPel = GetDeviceCaps( hDC, BITSPIXEL );
    ReleaseDC( hDlg, hDC );
    return wBitsPerPel;
}

VOID OnDeviceChange( HWND hDlg, UINT uiType, 
                     DEV_BROADCAST_HDR FAR *pdbt )
{
    DEV_BROADCAST_VOLUME FAR *pdbcv;
    switch( uiType )
    {
       case DBT_DEVICEARRIVAL:
          switch( pdbt->dbch_devicetype ) 
          {
             case DBT_DEVTYP_VOLUME:
                 pdbcv = (PDEV_BROADCAST_VOLUME) pdbt;
                 if( (pdbcv->dbcv_flags == DBTF_NET) ||
                     (pdbcv->dbcv_flags == DBTF_MEDIA) )
                 {
                    CHAR sz[20];
                    INT i=0;
                    while( !(pdbcv->dbcv_unitmask & (1 << i++)) );
                    wsprintf( sz, "The Drive is %C:", 'A'+i-1 );
                    MessageBox( hDlg, sz, PRG_NAME, 
                                MB_ICONINFORMATION );
                 }
                 break;
           }
           break;
       case DBT_DEVICEREMOVECOMPLETE:
           MessageBox( hDlg, 
              "Drive door open or network drive disconnected.",
              PRG_NAME, MB_ICONINFORMATION );
           break;
    }
    return;
}	
