@ECHO OFF

REM
REM Use DOS and Windows 95 programs that use the same COM-port without
REM conflicting.
REM

REM
REM This batch file is used for running FIDO2INT under Windows 95 while
REM having another DOS-task using McMail, but it can easily be modified
REM to any other Mailer that uses semaphore files to exist with certain
REM errorlevels.
REM
REM The reason for this construction is that Windows 95 locks the COM-port
REM when a DOS-task first have used the COM-port. The only resonable save
REM way I have discovered yet is to shut down the DOS window, run my
REM Windows programs and then restart the DOS-task again afterwards.
REM
REM With my setup I have a DOS-window called EVENT which is this batchfile
REM that always is open and does not run any programs that use the COM-port.
REM The EVENTER and WAIT programs that I made detects Windows and releases
REM timeslices and will not take up any CPU-time at all.
REM
REM                                         Bo Bendtsen
REM                                         www.terminate.com
REM

:Startup

REM
REM This section starts up a new DOS-window with my mailer (McMail)
REM Note that I use the Windows 95 command START to do this!
REM I delete the semaphore files just in case it was there already,
REM so I can be sure that Mcmail does not exist at once.
REM

 C:
 CD \MCMAIL
 DEL MCMEXT1.000 >NUL
 START POP.BAT

:Event

REM
REM Here I call my little event program (sourcecode included) which
REM exists with errorlevels at certain time you specify. Look in
REM EVENTER.CFG to see how easy it is to set up. I call FIDO2INT twice
REM a day in the morning at 06:00 and in the evening when the rates
REM are cheaper at 18:15
REM
REM I defined it to errorlevel 100, but you can change it to whatever
REM you like. If you include more errorlevels, please remember to put
REM them in reverse order (highest first).
REM

 K:
 CD \BBS\MAILER
 EVENTER
 IF ERRORLEVEL == 100 GOTO Internet
 Goto End

REM
REM I need to give time to shut down my DOS-window
REM

:Wait1
 Wait 10
 Goto DoneWait1

:Wait2
 Wait 10
 Goto DoneWait2

:Wait3
 Wait 10
 Goto DoneWait3

:Internet

REM
REM With the following command I create a file called MCMEXT1.000 which
REM makes my McMail exist with errorlevel 0, which will close down the
REM DOS-window entirely. Afterwards I wait a little and check some more
REM semaphore files to make sure that the DOS-window really is closed.
REM

 ECHO Closing down BBS-task
 ECHO x>MCMEXT1.000

 IF EXIST MCMRUN.1 GOTO WAIT1
 IF EXIST MCMBBS.1 GOTO WAIT1
 IF EXIST MCMFAX.1 GOTO WAIT1
 :DoneWait1
 IF EXIST MCMRUN.1 GOTO WAIT2
 IF EXIST MCMBBS.1 GOTO WAIT2
 IF EXIST MCMFAX.1 GOTO WAIT2
 :DoneWait2
 IF EXIST MCMRUN.1 GOTO WAIT3
 IF EXIST MCMBBS.1 GOTO WAIT3
 IF EXIST MCMFAX.1 GOTO WAIT3
 :DoneWait3
 IF EXIST MCMRUN.1 GOTO EVENT
 IF EXIST MCMBBS.1 GOTO EVENT
 IF EXIST MCMFAX.1 GOTO EVENT

REM
REM I give a little more time to close the window down
REM

 ECHO Give mailer window a little time to shutdown
 WAIT 5

REM
REM Now I call FIDO2INT with the /AUTO which makes FIDO2INT close down
REM at once after it is finished. By using the Windows 95 command START.EXE
REM and the /WAIT command, the batchfile is paused until FIDO2INT.EXE is
REM finished. After that I wait 10 seconds to allow FIDO2INT to shut down.
REM and restart my mailer task in a new DOS-window.
REM

 ECHO Start Fido2Int and do not return to batchfile before finished
 CD \FIDO2INT
 START /WAIT FIDO2INT.EXE /AUTO
 WAIT 10

 IF EXIST MCMRUN.1 GOTO Event
 ECHO Restarting BBS-task in a new Windows
 C:
 CD \BBS\MAILER
 DEL MCMEXT1.000 >NUL
 START POP.BAT
 Goto Event

:End
 ECHO x>MCMEXT1.000

