//  To build this program from the command line, 
//  be sure to include both source files: 
// 
//  bcc32 bug1096a.cpp bug1096b.cpp 
// 
//  bcc bug1096a.cpp bug1096b.cpp 
// 
//  cl bug1096a.cpp bug1096b.cpp 
//

#include <iostream.h>

// Note that I force this function to extern
// using a separate declaration.  Borland's
// compiler refuses to compile a function
// declared specifically as "extern inline".
//
extern int ext();

int inline ext()
{
    static int i = 0;
    return ++i;
}

// This function should be static without the explicit declaration,
// but VC++ doesn't treat it as static without the extra keyword.

static int inline stat()
{
    static int i = 0;
    return ++i;
}

void a()
{
    cout << "On pass #1, ext() and stat() should both return 1\n";
    cout << "From unit a, ext() returns "  << ext()
         << ", stat() returns "            << stat()  << "\n";
    cout << "Address of ext() is "     << (void *) ext
         << ", address of stat() is "  << (void *) stat << "\n";
}

extern void b();

main()
{
    a();
    b();
    return 1;
}
