%
% "secant.t" solve for multiple complex roots
% using the secant method
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const MAXIT : int := 20
const ROOTS : int := 3
type carray : array[ROOTS] of complex


program

    var init, step : carray
    var root, this, prev : complex
    var i : int

    % you must set initial search points

    init[0].re := 1.0
    init[0].im := 0.0
    step[0].re :=-0.1
    step[0].im := 0.0
    
    init[1].re := 0.0
    init[1].im := 1.0
    step[1].re := 0.1
    step[1].im := 0.1

    init[2].re := 0.0
    init[2].im :=-1.0
    step[2].re :=-0.1
    step[2].im :=-0.1

    for i := 0...ROOTS-1 do

        this.re := init[i].re
        this.im := init[i].im
        prev.re := init[i].re - step[i].re
        prev.im := init[i].im - step[i].im

        search( root, this, prev )

        put "root =", cstr( root )

    end for
        
end program

%
% evaluate function: fn(x) = x^3 - 2 x^2 + 4 x - 8
%
procedure fn( var dest, srce : complex )

    var temp3, temp2, temp1, temp : complex
    
    % x^3 term
    cmov( temp3, srce )
    cmul( temp3, srce )
    cmul( temp3, srce )
    
    % x^2 term
    cmov( temp2, srce )
    cmul( temp2, srce )
    temp2.re := temp2.re * 2
    temp2.im := temp2.im * 2

    % x term
    cmov( temp1, srce )
    temp1.re := temp1.re * 4
    temp1.im := temp1.im * 4

    cmov( temp, temp3 )
    csub( temp, temp2 )
    cadd( temp, temp1 )
    temp.re := temp.re - 8.0

    cmov( dest, temp )

end procedure    

%
% search for a root using the secant method
%
procedure search( var root, this, prev : complex )

    var dx, dfn, fn_this, fn_prev, next, delta : complex
    var i : int

    for i := 0...MAXIT do

        cmov( dx, this )
        csub( dx, prev )

        fn( fn_this, this )
        fn( fn_prev, prev )
        cmov( dfn, fn_this )
        csub( dfn, fn_prev )

        if cabs( dfn ) < 1.0e-99 then
            exit
        end if

        cmov( delta, fn_this )
        cmul( delta, dx )
        cdiv( delta, dfn )

        cmov( next, this )
        csub( next, delta )

        cmov( prev, this )
        cmov( this, next )

    end for

    cmov( root, next )
    
end procedure