%
% "roman.t" converts integers < 4000 into roman numerals
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const wh : string := "IVXLCDM"

program

    var in : int

    loop

        prompt "integer ( <1 to stop ):"
        get in

        exit when in < 1

        put in, " = ", roman( in )

    end loop

end program


%
%   convert from integer to roman numeral
%
function roman( in : int ) : string

    label roman_exit:
    var number, divisor : int
    var i, j, k, p : int
    var str : string

    number := in
    divisor := 1000
    p := 0

    if number >= 4000 then

        str := "Too big, re-enter"
        goto roman_exit

    end if

    for decreasing k := 3 ... 0 do
        
        i := number div divisor
        number := number mod divisor

        case i of

            value 0:
                % do nothing

            value 5:
                str[p] := wh[2*k+1]
                p := p + 1

            value 9:
                str[p] := wh[2*k]
                p := p + 1
                str[p] := wh[2*k+2]
                p := p + 1

            value 4:
                str[p] := wh[2*k]
                p := p + 1
                str[p] := wh[2*k+1]
                p := p + 1

            value : 
                if i > 5 then
                    str[p] := wh[2*k+1]
                    p := p + 1
                    i := i - 5
                end if
                for j := 0 ... i-1 do
                    str[p] := wh[2*k]
                    p := p + 1
                end for

        end case

        divisor := divisor div 10

    end for

    str[p] := chr( 0 )

    roman_exit:
    return str

end function