%
% "permute.t" shows all permutations of a sequence of
% integers
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const num : int := 4
var a : array[num] of int
var pos : int

program

    var i : int

    pos := -1

    for i := 1 ... num-1 do 

        a[i] := 0

    end for
    
    permute( 0 )

end program

%
% arrange global array a in all possible ways
%
procedure permute( n : int )

    var i : int

    pos := pos + 1
    a[n] := pos
    
    if pos = num-1 then 

        show_array

    end if
   
    if pos ~= num - 1 then

        for i := 0...num-1 do

            if a[i] = 0 then 

                permute( i )

            end if

        end for

    end if
   
    pos := pos - 1
    a[n] := 0

end procedure

%
% display contents of global array a 
%
procedure show_array

    var i : int

    for i := 0 ... num-1 do 

        put a[i] : 3 ...

    end for

    put ""
   
end procedure