%
%  "lister.t" lists T source programs and adds line numbers
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

type file_name : string

var Main_file_name : file_name
var Main_file : int
var Line_buffer: string


program

    open_main
    process_file

end program


procedure open_main

    prompt "main file name:"
    get Main_file_name

    Main_file := open( Main_file_name, "r" )
    if Main_file = 0 then

        put "ERROR -- File not found: ", Main_file_name
        assert false

    end if

end procedure


procedure process_file

    var n : int := 0

    loop

        exit when eof( Main_file) 
        get :Main_file, Line_buffer : *
        incr n
        put n:3, ": ", Line_buffer 
        Line_buffer := ""
    
    end loop

    if close( Main_file ) = 0 then

        put "file close error"

    end if

end procedure
