// ***** TEST.C *****
// For testing the Tasker32 routines.
// If you have the shareware version compile with -DSHAREWARE

//Load includes
#include "task32.h"                 //Load this first!!
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <stdlib.h>

//Global variables
ulong     count[TASK_NUM]={0,0,0,0,0,0,0,0,0,0};  //Some counts
ushort    tid[TASK_NUM+1];                        //Task ID's
ushort    SS;                                     //Stack seg
ulong     ESP;                                    //Stack ptr
ushort    scrtop;                                 //Line for top of display

//Func prototypes
void Hnd(ushort);                   //Handler declaration

void main()
{
  //Some variables:
  time_t  *curtime;                 //Gets the time
  int     k;                        //from getch() and a counter
  ushort  next=0;                   //Next task to add

  //Initilize the tasker and check for error
  clrscr();
  if( task_init_tasker() != TASK_OK ) {
    puts("ERROR: Failed to init tasker");
    return;
  }
  atexit((void (*)())task_end_tasker);

  //Initialize screen garbage
  printf("[A]dd Task  [D]elete Task  [P]ause  [U]npause\n");
  scrtop=wherey();
  for(k=0;k<TASK_NUM;k++)
    printf(" Task %1d\n",k);

  //Run the tasker
  while( (k=getch())!=27 ) {
    if(k=='a' || k=='A') {
      tid[next]=task_add(random(50)+18,Hnd,_CS,_DS,0);
      #ifndef SHAREWARE
        if(tid[next]!=TASK_NONE_FREE) {
          gotoxy(30,tid[next]+scrtop);
          printf("%2uHz",tasks[tid[next++]].freq);
        }
      #else
        next++;
      #endif
    } else if(k=='d' || k=='D') {
      if(next>0) task_delete(tid[--next]);
    } else if(k=='p' || k=='P') {
      task_setstatus(tid[next-1],TASK_PAUSED);
    } else if(k=='u' || k=='U') {
      task_clearstatus(tid[next-1],TASK_PAUSED);
    }
  }
  task_end_tasker();

  //Display some stuff
  gotoxy(1,10+scrtop);
  printf("Ended...... SS=%04X _SS=%04X  ESP=%08lX  _ESP=%08X",
              SS,_SS,ESP,_ESP);
  #ifndef SHAREWARE
    for(k=0;k<TASK_NUM;k++) {
      printf("\ntid=%d  count=%8u  status=%5hu  delay=%6u  freq=%6u",
        k,count[k],tasks[k].status,tasks[k].delay,tasks[k].freq);
    }
  #endif
}

void Hnd(const ushort tid)            //Main handler
{
  SS=_SS; ESP=_ESP;
  gotoxy(10,tid+scrtop); 
  printf("%u",++count[tid]);
}

