{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; simple searching of stream contents

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBIO, CRT;

const SearchCache = 16000; { Higher value gives better perfomance }

var SearchStream : StreamObjectPointerType; Data : string;


begin
     if FileExists(ParamStr(1)) and (ParamStr(2) <> '') then begin
        WriteLn ('* Searching *');

        { Initialize a file stream that we will search }
        SearchStream := New (FileStreamObjectPointerType,
                             Initialize (ParamStr(1), SearchCache));

        { Perform an un-optimized search; 1) read string of
          the same length as the searched string from the stream,
          2) compare strings and 3) walk backwards to the character
          after beginning of the read string. }

        while not SearchStream^.IsEnd and (Data <> ParamStr(2)) do
              with SearchStream^ do begin

              { Read a string from the stream }
              Read (Data[1], Length(ParamStr(2)));
              Data[0] := Chr(LastTransfer);
              { Seek backwards }
              if (Position > Pred(Length(ParamStr(2)))) and (Position < Size) then
                 Seek (Position - Pred(Length(ParamStr(2))));

        end;

        if (Data = ParamStr(2)) then WriteLn ('Found at ', SearchStream^.Position, '.')
           else WriteLn ('Not found.');

        SearchStream^.Free;

     end else WriteLn ('This program only run with file and search string parameters.');
end.