{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; bouncing indicators

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBOBJ, EFLIBIO, EFLIBWIN, EFLIBMSE,
     EFLIBKBD, EFLIBTXT, EFLIBSCR, CRT;

var Indicator1, Indicator2, Indicator3 : IndicatorObjectPointerType;
    Window : WindowObjectType;
    Bounce : integer;


begin
     Screen.Draw;

     { Show a information window ... }
     with Window do begin
          Initialize;
          SetHeader ('Bouncing indicators');
          SetBorder (ThinBorder);
          DisableExplode; EnableKeep; DisableCloseButton;
          SetCoordinates (5, 2, 52, 9);
          SetTextCoordinates (7, 3, 50, 8);
          Draw;

          WriteLn ('@Yellow:Blue@@C@Indicators are visual objects that show');
          WriteLn ('@C@the position inside an output.');
          LineFeed;
          WriteLn ('@LightGreen:Blue@@C@EFLIB opens an entire new world of');
          Write   ('@C@programming!');
          Intercept;
     end;

     { Create three indicators - one of each kind }
     New (Indicator1, Initialize (5, 12, 54, 12, 1, 100));
     New (Indicator2, Initialize (2, 23, 79, 23, 1, 100));
     New (Indicator3, Initialize (60, 2, 60, 21, 1, 100));

     Screen.HideCursor;
     Indicator1^.Draw; Indicator2^.Draw; Indicator3^.Draw;

     with Mouse, Keyboard do repeat
           { Bounce indicators ... }
           for Bounce := 1 to 100 do begin
               Delay(5);
               Indicator1^.Update (Bounce);
               Indicator2^.Update (Bounce);
               Indicator3^.Update (Bounce);
               if KeyPressed or ButtonPressed then Break;
           end;
           for Bounce := 100 downto 1 do begin
               Delay(5);
               if KeyPressed or ButtonPressed then Break;
               Indicator1^.Update (Bounce);
               Indicator2^.Update (Bounce);
               Indicator3^.Update (Bounce);
           end;
     until KeyPressed or ButtonPressed;

     { Dispose objects }
     Indicator1^.Free; Indicator2^.Free; Indicator3^.Free;
end.