{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; queues #1

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBWIN, EFLIBDAT, EFLIBTXT, EFLIBKBD;


var MyWindow : WindowObjectType;
    MyQueue : QueueObjectType; Data : string[63]; Index : word;
    NumberOfElements : word; StartMemory, MemoryUsed : longint; DataFlow : real;
    RunTimer : TimerObjectType; Intact : boolean;


begin
     StartMemory := MemAvail; RunTimer.Initialize;

     RandSeed := 0; { Control random seed }

     with MyWindow do begin
          { Initialize a text window }
          InitializeWindow (1, 1, 80, 25, 'EFLIB', NoBorder, FALSE, FALSE);
          SetTextCoordinates (3, 3, 78, 24);

          WriteLn ('@C@@LightGreen:Blue@* Queues *');
          WriteLn ('@C@@White:Blue@All data types have many common features. Queues can be');
          WriteLn ('@C@circular and reversed.');
          WriteLn ('@Yellow:Blue@'); LineFeed;

          RunTimer.Reset;

          { Build queue }
          WriteLn ('@LightRed:Blue@');
          WriteLn ('Building a queue (adding as many element as memory can keep) ...');

          MyQueue.InitializeQueue (SizeOf(Data), { Element size }
                                   TRUE,  { Circular access is enabled }
                                   TRUE); { Skip extra safety checkings }


          NumberOfElements := 0;
          while MyQueue.IsFree and not GlobalDataError do begin
                Inc (NumberOfElements);
                Data := StringGeneratedRandomly (Pred(SizeOf(Data)));
                MyQueue.Store (Data);
          end;

          MemoryUsed := (StartMemory - MemAvail);

          WriteLn ('@Yellow:Blue@Cycles through the queue one time and retrieves all elements ... ');
          for Index := 1 to NumberOfElements do MyQueue.Retrieve (Data);

          WriteLn ('@LightGreen:Blue@Done.');
          WriteLn ('');
          WriteLn ('');

          Intact := MyQueue.IsIntact;

          { Intercept object (and dispose all elements from the heap) }
          MyQueue.Intercept;

          DataFlow := (MemoryUsed / (1 + RunTimer.ElapsedMS)) * 1e3;

          WriteLn ('@White:Blue@DATA FLOW ANALYZIS');
          WriteLn ('@Yellow:Blue@Builded '+StringNumber(NumberOfElements, 0, 0)+' elements at '+
                   StringNumber(RunTimer.ElapsedMS, 0, 0)+' ms, with an average data flow of '+
                   StringNumber(DataFlow, 0, 0));
          WriteLn ('byte per second and a total data allocation of '+StringNumber(MemoryUsed, 0, 0)+' bytes.');
          WriteLn ('');

          WriteLn ('@White:Blue@');
          WriteLn ('[Intact]  :  ' + StringBoolean (Intact));
          WriteLn ('[Errors]  :  ' + StringBoolean (GlobalErrorFlag or GlobalDataError));

          repeat until Keyboard.KeyPressed;

          Intercept;
     end;
end.
