{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; linked list node walking

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT, CRT;

var MyList : TextObjectType;
    MyNode : LinkageObjectPointerType;


{ Far procedure to pass as a parameter to the ForEach method }
procedure View (var Data : string; var Continue : boolean); far;
begin
     Write (Data, ' ');
end;


begin
     with MyList do begin
          { Initialize a structure based on text strings }
          Initialize;

          { Add some nodes to the structure }
          AddText ('With'); AddText ('node'); AddText ('walking'); AddText ('it''s');
          AddText ('very'); AddText ('easy'); AddText ('to'); AddText ('access');
          AddText ('the'); AddText ('node'); AddText ('you'); AddText ('want');
          AddText ('to'); AddText ('access.');

          { Walk to the last node using the the node two nodes before the last
            node as starting node for the walk. }
          MyNode := LastNode^.Predecessor^.Predecessor;
          Walk (MyNode, 2);
          WriteLn ('We have now walked two nodes to the last node (', NodeIndex(MyNode), ').');

          { Walk forward two nodes }
          Walk (MyNode, -2);
          WriteLn ('Back there we started walking (', NodeIndex(MyNode), ').');

          { Walk to the node two nodes after the first node (relatively). }
          WalkUsing (MyNode, FirstNode, 2);
          WriteLn ('Walked two steps forward from first node (', NodeIndex(MyNode), ').');

          { Walk to the node two nodes after the first node (relatively). }
          WalkUsing (MyNode, MyNode, -2);
          WriteLn ('Walked back again (', NodeIndex(MyNode), ').');

          { Display the nodes }
          WriteLn; ForEach (@View); WriteLn;

          { Dispose structure (intercept object }
          Intercept;
     end;

     if GlobalDataError then WriteLn ('Error(s) reported!');
end.