{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration of nested initialization of linked structures

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT;


const Data : array [1..5] of string = ('Entry one', 'Entry two', 'Entry three',
             'Entry four', 'Entry five');

var MyList : LinkedListObjectType;



begin
     with MyList do begin
          { Initialize structure and chain some nodes }
          InitializeChain (SizeOf(Data[1]),
            New (GenericLinkageObjectPointerType, InitializeChain (Data[1], SizeOf(Data[1]),
            New (GenericLinkageObjectPointerType, InitializeChain (Data[2], SizeOf(Data[2]),
            New (GenericLinkageObjectPointerType, InitializeChain (Data[3], SizeOf(Data[3]),
            New (GenericLinkageObjectPointerType, InitializeChain (Data[4], SizeOf(Data[4]),
            New (GenericLinkageObjectPointerType, InitializeChain (Data[5], SizeOf(Data[5]), NIL)))))))))));

          { The complex initialization could be replaced with:
               Initialize (SizeOf(Data[1]);
               Add (Data[1]); Add (Data[2]);
               Add (Data[3]); Add (Data[4]); Add (Data[5]); }

          { Display elements }
          with CreateIterator^ do begin { Allocate iterator object }
               repeat
                     WriteLn (String(Content^));
                     WalkForward; { Next element }
               until IsEnd;
               Free; { Iterator }
          end;

          Intercept;
     end;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.