{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; polymorphic elements for abstract data types #1

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBDAT;

var Element1, Element2,
    Element3, Element4, SomeNode : LinkageObjectPointerType;
    SomeString : string; Index : word;


begin
     { Create a sample generic element for doubly linked data structures }
     SomeString := 'Some basic data for the first element';
     Element1 := New (GenericLinkageObjectPointerType,
                 Initialize (SomeString, SizeOf(SomeString)));

     { Create one more element ... }
     SomeString := 'Even more data for another element';
     Element2 := New (GenericLinkageObjectPointerType,
                 Initialize (SomeString, SizeOf(SomeString)));

     { Create an epty element }
     SomeString := '';
     Element3 := New (GenericLinkageObjectPointerType,
                 InitializeEmpty);

     { Duplicate the second element into a forth element }
     Element4 := New (GenericLinkageObjectPointerType,
                 InitializeDuplicate (Element2));

     if Element4^.IsAllocated then { Verify that we actually duplicated an element }
        WriteLn ('Duplicated an element');

     { Put elements together in a simple structure of linked elements }
     Element1^.AttachAfter (Element2); { Attach second node after first }
     Element2^.AttachAfter (Element3); { ... and the third after the second }
     Element2^.AttachBefore (Element4); { ... and the forth element before the second }

     { Now we've got a very simple linked data structure without any
       implementation into an advanced ADT. }

     SomeNode := Element1; { Start with first node }
     for Index := 1 to 4 do begin
         { One node will not be showed, hence it isn't allocated! }
         if SomeNode^.IsIntact then { Just check that all links are intact }
            WriteLn (Index:0, ': ', String(SomeNode^.DataPointer(0)^));
         SomeNode := SomeNode^.Successor; { Go to the successor }
     end;

     WriteLn ('Three nodes should be displayed, since the last node is empty.');

     { When elements are disposed, they're automatically detached
       from any linked structure }
     Element1^.Free; Element2^.Free; Element4^.Free; Element3^.Free;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.